/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import java.util.List;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueList;
import org.dspace.app.rest.model.TemplateItemRest;
import org.dspace.app.rest.model.wrapper.TemplateItem;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.Collection;
import org.dspace.content.service.ItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateItemConverter
implements DSpaceConverter<TemplateItem, TemplateItemRest> {
    @Autowired
    ConverterService converter;
    @Autowired
    private ItemService itemService;

    public TemplateItemRest convert(TemplateItem templateItem, Projection projection) {
        TemplateItemRest templateItemRest = new TemplateItemRest();
        templateItemRest.setProjection(projection);
        if (templateItem.getID() != null) {
            templateItemRest.setId((Serializable)templateItem.getID());
            templateItemRest.setUuid(templateItem.getID());
        }
        templateItemRest.setLastModified(templateItem.getLastModified());
        Collection templateItemOf = templateItem.getTemplateItemOf();
        if (templateItemOf != null) {
            templateItemRest.setTemplateItemOf((CollectionRest)this.converter.toRest((Object)templateItemOf, projection));
        }
        List fullList = this.itemService.getMetadata(templateItem.getItem(), "*", "*", "*", "*", true);
        MetadataValueList metadataValues = new MetadataValueList(fullList);
        templateItemRest.setMetadata((MetadataRest)this.converter.toRest((Object)metadataValues, projection));
        return templateItemRest;
    }

    public Class<TemplateItem> getModelClass() {
        return TemplateItem.class;
    }
}

