/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.WorkflowActionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.workflowaction")
public class WorkflowActionRestRepository
extends DSpaceRestRepository<WorkflowActionRest, String> {
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public WorkflowActionRest findOne(Context context, String workflowActionName) {
        WorkflowActionConfig actionConfig = this.xmlWorkflowFactory.getActionByName(workflowActionName);
        if (actionConfig != null) {
            return (WorkflowActionRest)this.converter.toRest((Object)actionConfig, this.utils.obtainProjection());
        }
        throw new ResourceNotFoundException("No workflow action with name " + workflowActionName + " is configured");
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<WorkflowActionRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("workflowaction", "findAll");
    }

    public Class<WorkflowActionRest> getDomainClass() {
        return WorkflowActionRest.class;
    }
}

