/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.handler.service;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.repository.handler.UriListHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UriListHandlerService {
    @Autowired
    private List<UriListHandler> uriListHandlers;

    public <T> T handle(Context context, HttpServletRequest request, List<String> uriList, Class<T> clazz) throws SQLException, AuthorizeException {
        for (UriListHandler uriListHandler : this.uriListHandlers) {
            if (!uriListHandler.supports(uriList, request.getMethod(), clazz)) continue;
            if (uriListHandler.validate(context, request, uriList)) {
                return (T)uriListHandler.handle(context, request, uriList);
            }
            throw new DSpaceBadRequestException("The input given to the UriListHandler was invalid");
        }
        throw new DSpaceBadRequestException("No UriListHandler was found that supports the inputs given");
    }
}

