/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.HttpHeadersInitializer;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/${sitemap.path:sitemaps}"})
public class SitemapRestController {
    private static final Logger log = LogManager.getLogger(SitemapRestController.class);
    @Autowired
    ConfigurationService configurationService;
    private static final int BUFFER_SIZE = 40960;

    @GetMapping(value={"/{name}"})
    public ResponseEntity retrieve(@PathVariable String name, HttpServletResponse response, HttpServletRequest request) throws IOException, SQLException {
        File foundSitemapFile = null;
        File sitemapOutputDir = new File(this.configurationService.getProperty("sitemap.dir"));
        if (sitemapOutputDir.exists() && sitemapOutputDir.isDirectory()) {
            File[] sitemapFilesList;
            for (File sitemapFile : sitemapFilesList = sitemapOutputDir.listFiles()) {
                if (!name.equalsIgnoreCase(sitemapFile.getName())) continue;
                if (sitemapFile.isFile()) {
                    foundSitemapFile = sitemapFile;
                    continue;
                }
                throw new ResourceNotFoundException("Directory with name " + name + " in " + sitemapOutputDir.getAbsolutePath() + " found, but no file.");
            }
        } else {
            throw new ResourceNotFoundException("Sitemap directory in " + sitemapOutputDir.getAbsolutePath() + " does not exist, either sitemaps have not been generated (./dspace generate-sitemaps), or are located elsewhere (config used: sitemap.dir).");
        }
        if (foundSitemapFile == null) {
            throw new ResourceNotFoundException("Could not find sitemap file with name " + name + " in " + sitemapOutputDir.getAbsolutePath());
        }
        return this.returnSitemapFile(foundSitemapFile, response, request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseEntity returnSitemapFile(File foundSitemapFile, HttpServletResponse response, HttpServletRequest request) throws SQLException, IOException {
        try (FileInputStream is = new FileInputStream(foundSitemapFile);){
            HttpHeadersInitializer sender = HttpHeadersInitializer.fromInputStream(is).withBufferSize(40960).withFileName(foundSitemapFile.getName()).withLength(foundSitemapFile.length()).withMimetype(Files.probeContentType(foundSitemapFile.toPath())).with(request).with(response);
            sender.withLastModified(foundSitemapFile.lastModified());
            long dispositionThreshold = this.configurationService.getLongProperty("webui.content_disposition_threshold");
            if (dispositionThreshold >= 0L && foundSitemapFile.length() > dispositionThreshold) {
                sender.withDisposition("attachment");
            }
            Context context = ContextUtil.obtainContext(request);
            context.complete();
            if (!sender.isValid()) return null;
            HttpHeaders httpHeaders = sender.initialiseHeaders();
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).body((Object)new FileSystemResource(foundSitemapFile));
            return responseEntity;
        }
        catch (ClientAbortException e) {
            log.debug("Client aborted the request before the download was completed. Client is probably switching to a Range request.", (Throwable)e);
        }
        return null;
    }
}

