/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationFeatureServiceImpl
implements AuthorizationFeatureService {
    @Autowired
    private List<AuthorizationFeature> features;
    @Autowired
    private Utils utils;

    @Override
    public boolean isAuthorized(Context context, AuthorizationFeature feature, BaseObjectRest object) throws SQLException {
        if (object == null) {
            return false;
        }
        if (feature == null || !ArrayUtils.contains((Object[])feature.getSupportedTypes(), (Object)object.getUniqueType())) {
            return false;
        }
        return feature.isAuthorized(context, object);
    }

    @Override
    public List<AuthorizationFeature> findAll() {
        return this.features;
    }

    @Override
    public AuthorizationFeature find(String name) {
        for (AuthorizationFeature feature : this.features) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)feature.getName())) continue;
            return feature;
        }
        return null;
    }

    @Override
    public List<AuthorizationFeature> findByResourceType(String categoryDotType) {
        return this.features.stream().filter(f -> ArrayUtils.contains((Object[])f.getSupportedTypes(), (Object)categoryDotType)).collect(Collectors.toList());
    }
}

