/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.List;
import java.util.Map;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.HarvestStatusEnum;
import org.dspace.app.rest.model.HarvestTypeEnum;
import org.dspace.app.rest.model.HarvestedCollectionRest;
import org.dspace.app.rest.model.HarvesterMetadataRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.Collection;
import org.dspace.harvest.HarvestedCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HarvestedCollectionConverter
implements DSpaceConverter<HarvestedCollection, HarvestedCollectionRest> {
    @Autowired
    private ConverterService converter;

    @Override
    public HarvestedCollectionRest convert(HarvestedCollection obj, Projection projection) {
        HarvestedCollectionRest harvestedCollectionRest = new HarvestedCollectionRest();
        harvestedCollectionRest.setProjection(projection);
        if (obj != null) {
            HarvestTypeEnum harvestTypeEnum = HarvestTypeEnum.fromInt(obj.getHarvestType());
            HarvestStatusEnum harvestStatusEnum = HarvestStatusEnum.fromInt(obj.getHarvestStatus());
            harvestedCollectionRest.setId(obj.getID());
            harvestedCollectionRest.setCollection((CollectionRest)this.converter.toRest(obj.getCollection(), projection));
            harvestedCollectionRest.setHarvestType(harvestTypeEnum);
            harvestedCollectionRest.setHarvestStatus(harvestStatusEnum);
            harvestedCollectionRest.setMetadataConfigId(obj.getHarvestMetadataConfig());
            harvestedCollectionRest.setOaiSetId(obj.getOaiSetId());
            harvestedCollectionRest.setOaiSource(obj.getOaiSource());
            harvestedCollectionRest.setHarvestMessage(obj.getHarvestMessage());
            harvestedCollectionRest.setHarvestStartTime(obj.getHarvestStartTime());
            harvestedCollectionRest.setLastHarvested(obj.getHarvestDate());
        } else {
            harvestedCollectionRest.setHarvestType(HarvestTypeEnum.NONE);
        }
        return harvestedCollectionRest;
    }

    public HarvestedCollectionRest fromModel(HarvestedCollection obj, Collection collection, List<Map<String, String>> metadata_configs, Projection projection) {
        HarvestedCollectionRest harvestedCollectionRest = this.convert(obj, projection);
        if (obj == null) {
            harvestedCollectionRest.setCollection((CollectionRest)this.converter.toRest(collection, projection));
        }
        HarvesterMetadataRest harvesterMetadataRest = new HarvesterMetadataRest();
        harvesterMetadataRest.setProjection(projection);
        harvesterMetadataRest.setConfigs(metadata_configs);
        harvestedCollectionRest.setMetadataConfigs(harvesterMetadataRest);
        return harvestedCollectionRest;
    }

    @Override
    public Class<HarvestedCollection> getModelClass() {
        return HarvestedCollection.class;
    }
}

