/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Bundle;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bundle.primaryBitstream")
public class BundlePrimaryBitstreamLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    BundleService bundleService;

    @PreAuthorize(value="hasPermission(#bundleId, 'BUNDLE', 'READ')")
    public BitstreamRest getPrimaryBitstream(@Nullable HttpServletRequest request, UUID bundleId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Bundle bundle = (Bundle)this.bundleService.find(context, bundleId);
            if (bundle == null) {
                throw new ResourceNotFoundException("No such bundle: " + bundleId);
            }
            if (bundle.getPrimaryBitstream() == null) {
                return null;
            }
            return (BitstreamRest)this.converter.toRest(bundle.getPrimaryBitstream(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

