/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.collection.mappedItems")
public class CollectionMappedItemLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    CollectionService collectionService;
    @Autowired
    ItemService itemService;

    @PreAuthorize(value="hasPermission(#collectionId, 'COLLECTION', 'READ')")
    public Page<ItemRest> getMappedItems(@Nullable HttpServletRequest request, UUID collectionId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Collection collection = (Collection)this.collectionService.find(context, collectionId);
            if (collection == null) {
                throw new ResourceNotFoundException("No such collection: " + collectionId);
            }
            int total = this.itemService.countByCollectionMapping(context, collection);
            Pageable pageable = this.utils.getPageable(optionalPageable);
            ArrayList items = new ArrayList();
            this.itemService.findByCollectionMapping(context, collection, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset()))).forEachRemaining(items::add);
            return this.converter.toRestPage(items, pageable, total, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

