/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.utils.CommunityRestEqualityUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="core.community")
public class CommunityRestRepository
extends DSpaceObjectRestRepository<Community, CommunityRest> {
    private static final Logger log = LogManager.getLogger(CommunityRestRepository.class);
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    CommunityRestEqualityUtils communityRestEqualityUtils;
    @Autowired
    private GroupService groupService;
    @Autowired
    SearchService searchService;
    @Autowired
    AuthorizeService authorizeService;
    private CommunityService cs;

    public CommunityRestRepository(CommunityService dsoService) {
        super(dsoService);
        this.cs = dsoService;
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected CommunityRest createAndReturn(Context context) throws AuthorizeException {
        Community community = this.createCommunity(context, null);
        return (CommunityRest)this.converter.toRest(community, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'ADD')")
    protected CommunityRest createAndReturn(Context context, UUID id) throws AuthorizeException {
        Community parent;
        if (id == null) {
            throw new DSpaceBadRequestException("Parent Community UUID is null. Cannot create a SubCommunity without providing a parent Community.");
        }
        try {
            parent = (Community)this.cs.find(context, id);
            if (parent == null) {
                throw new UnprocessableEntityException("Parent community for id: " + id + " not found");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Community community = this.createCommunity(context, parent);
        return (CommunityRest)this.converter.toRest(community, this.utils.obtainProjection());
    }

    private Community createCommunity(Context context, Community parent) throws AuthorizeException {
        Community community;
        CommunityRest communityRest;
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = req.getInputStream();
            communityRest = (CommunityRest)mapper.readValue((InputStream)input, CommunityRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body.", e1);
        }
        try {
            community = this.cs.create(parent, context);
            this.cs.update(context, (DSpaceObject)community);
            this.metadataConverter.mergeMetadata(context, community, communityRest.getMetadata());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return community;
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'READ')")
    public CommunityRest findOne(Context context, UUID id) {
        Community community = null;
        try {
            community = (Community)this.cs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (community == null) {
            return null;
        }
        return (CommunityRest)this.converter.toRest(community, this.utils.obtainProjection());
    }

    @Override
    public Page<CommunityRest> findAll(Context context, Pageable pageable) {
        try {
            if (this.authorizeService.isAdmin(context)) {
                long total = this.cs.countTotal(context);
                List communities = this.cs.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
                return this.converter.toRestPage(communities, pageable, total, this.utils.obtainProjection());
            }
            LinkedList<Community> communities = new LinkedList<Community>();
            DiscoverQuery discoverQuery = new DiscoverQuery();
            discoverQuery.setDSpaceObjectFilter(IndexableCommunity.TYPE);
            discoverQuery.setStart(Math.toIntExact(pageable.getOffset()));
            discoverQuery.setMaxResults(pageable.getPageSize());
            DiscoverResult resp = this.searchService.search(context, discoverQuery);
            long tot = resp.getTotalSearchResults();
            for (IndexableObject solrCommunities : resp.getIndexableObjects()) {
                Community c = (Community)((IndexableCommunity)solrCommunities).getIndexedObject();
                communities.add(c);
            }
            return this.converter.toRestPage(communities, pageable, tot, this.utils.obtainProjection());
        }
        catch (SQLException | SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="top")
    public Page<CommunityRest> findAllTop(Pageable pageable) {
        try {
            Context context = this.obtainContext();
            LinkedList<Community> topLevelCommunities = new LinkedList<Community>();
            DiscoverQuery discoverQuery = new DiscoverQuery();
            discoverQuery.setQuery("*:*");
            discoverQuery.setDSpaceObjectFilter(IndexableCommunity.TYPE);
            discoverQuery.addFilterQueries(new String[]{"-location.parent:*"});
            discoverQuery.setStart(Math.toIntExact(pageable.getOffset()));
            discoverQuery.setSortField("dc.title_sort", DiscoverQuery.SORT_ORDER.asc);
            discoverQuery.setMaxResults(pageable.getPageSize());
            DiscoverResult resp = this.searchService.search(context, discoverQuery);
            long tot = resp.getTotalSearchResults();
            for (IndexableObject solrCommunities : resp.getIndexableObjects()) {
                Community c = (Community)((IndexableCommunity)solrCommunities).getIndexedObject();
                topLevelCommunities.add(c);
            }
            return this.converter.toRestPage(topLevelCommunities, pageable, tot, this.utils.obtainProjection());
        }
        catch (SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="findAdminAuthorized")
    public Page<CommunityRest> findAdminAuthorized(Pageable pageable, @Parameter(value="query") String query) {
        try {
            Context context = this.obtainContext();
            List communities = this.authorizeService.findAdminAuthorizedCommunity(context, query, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
            long tot = this.authorizeService.countAdminAuthorizedCommunity(context, query);
            return this.converter.toRestPage(communities, pageable, tot, this.utils.obtainProjection());
        }
        catch (SQLException | SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    @Override
    public Class<CommunityRest> getDomainClass() {
        return CommunityRest.class;
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'WRITE')")
    protected CommunityRest put(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        CommunityRest communityRest;
        try {
            communityRest = (CommunityRest)new ObjectMapper().readValue(jsonNode.toString(), CommunityRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing community json: " + e.getMessage());
        }
        Community community = (Community)this.cs.find(context, id);
        if (community == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        CommunityRest originalCommunityRest = (CommunityRest)this.converter.toRest(community, this.utils.obtainProjection());
        if (!this.communityRestEqualityUtils.isCommunityRestEqualWithoutMetadata(originalCommunityRest, communityRest)) {
            throw new UnprocessableEntityException("The given JSON and the original Community differ more than just the metadata");
        }
        this.metadataConverter.setMetadata(context, community, communityRest.getMetadata());
        return (CommunityRest)this.converter.toRest(community, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'DELETE')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        Community community = null;
        try {
            community = (Community)this.cs.find(context, id);
            if (community == null) {
                throw new ResourceNotFoundException("core.community with id: " + id + " not found");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to find Community with id = " + id, e);
        }
        try {
            this.cs.delete(context, (DSpaceObject)community);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete Community with id = " + id, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete community because the logo couldn't be deleted", e);
        }
    }

    public BitstreamRest setLogo(Context context, Community community, MultipartFile uploadfile) throws IOException, AuthorizeException, SQLException {
        if (community.getLogo() != null) {
            throw new UnprocessableEntityException("The community with the given uuid already has a logo: " + community.getID());
        }
        Bitstream bitstream = this.cs.setLogo(context, community, uploadfile.getInputStream());
        this.cs.update(context, (DSpaceObject)community);
        this.bitstreamService.update(context, (DSpaceObject)bitstream);
        return (BitstreamRest)this.converter.toRest((Bitstream)context.reloadEntity((ReloadableEntity)bitstream), this.utils.obtainProjection());
    }

    public GroupRest createAdminGroup(Context context, HttpServletRequest request, Community community) throws SQLException, AuthorizeException {
        Group group = this.cs.createAdministrators(context, community);
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        try {
            List dcTitleMetadata;
            ServletInputStream input = request.getInputStream();
            groupRest = (GroupRest)mapper.readValue((InputStream)input, GroupRest.class);
            if (groupRest.isPermanent() || StringUtils.isNotBlank((CharSequence)groupRest.getName())) {
                throw new UnprocessableEntityException("The given GroupRest object has to be non-permanent and can't contain a name");
            }
            MetadataRest metadata = groupRest.getMetadata();
            SortedMap<String, List<MetadataValueRest>> map = metadata.getMap();
            if (map != null && (dcTitleMetadata = (List)map.get("dc.title")) != null && !dcTitleMetadata.isEmpty()) {
                throw new UnprocessableEntityException("The given GroupRest can't contain a dc.title mdv");
            }
            this.metadataConverter.setMetadata(context, group, metadata);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body.", e1);
        }
        return (GroupRest)this.converter.toRest(group, this.utils.obtainProjection());
    }

    public void deleteAdminGroup(Context context, Community community) throws SQLException, AuthorizeException, IOException {
        Group adminGroup = community.getAdministrators();
        this.cs.removeAdministrators(context, community);
        this.groupService.delete(context, (DSpaceObject)adminGroup);
    }
}

