/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.model.EntityTypeRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.dspace.external.service.ExternalDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.entitytype")
public class EntityTypeRestRepository
extends DSpaceRestRepository<EntityTypeRest, Integer> {
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private ExternalDataService externalDataService;

    @Override
    @PreAuthorize(value="permitAll()")
    public EntityTypeRest findOne(Context context, Integer integer) {
        try {
            EntityType entityType = (EntityType)this.entityTypeService.find(context, integer.intValue());
            if (entityType == null) {
                throw new ResourceNotFoundException("The entityType for ID: " + integer + " could not be found");
            }
            return (EntityTypeRest)this.converter.toRest(entityType, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Page<EntityTypeRest> findAll(Context context, Pageable pageable) {
        try {
            List entityTypes = this.entityTypeService.findAll(context);
            return this.converter.toRestPage(entityTypes, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="findAllByAuthorizedCollection")
    public Page<EntityTypeRest> findAllByAuthorizedCollection(Pageable pageable) {
        try {
            Context context = this.obtainContext();
            List types = this.entityTypeService.getSubmitAuthorizedTypes(context);
            List entityTypes = types.stream().map(type -> {
                if (StringUtils.isBlank((String)type)) {
                    return null;
                }
                try {
                    return this.entityTypeService.findByEntityType(context, type);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }).filter(x -> Objects.nonNull(x)).collect(Collectors.toList());
            return this.converter.toRestPage(entityTypes, pageable, this.utils.obtainProjection());
        }
        catch (IOException | SQLException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @SearchRestMethod(name="findAllByAuthorizedExternalSource")
    public Page<EntityTypeRest> findAllByAuthorizedExternalSource(Pageable pageable) {
        try {
            Context context = this.obtainContext();
            List types = this.entityTypeService.getSubmitAuthorizedTypes(context);
            List entityTypes = types.stream().filter(x -> this.externalDataService.getExternalDataProvidersForEntityType(x).size() > 0).map(type -> {
                if (StringUtils.isBlank((String)type)) {
                    return null;
                }
                try {
                    return this.entityTypeService.findByEntityType(context, type);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }).filter(x -> Objects.nonNull(x)).collect(Collectors.toList());
            return this.converter.toRestPage(entityTypes, pageable, this.utils.obtainProjection());
        }
        catch (IOException | SQLException | SolrServerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<EntityTypeRest> getDomainClass() {
        return EntityTypeRest.class;
    }
}

