/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.Thumbnail;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.item.thumbnail")
public class ItemThumbnailLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    ItemService itemService;

    @PreAuthorize(value="hasPermission(#itemId, 'ITEM', 'READ')")
    public BitstreamRest getThumbnail(@Nullable HttpServletRequest request, UUID itemId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, itemId);
            if (item == null) {
                throw new ResourceNotFoundException("No such item: " + itemId);
            }
            Thumbnail thumbnail = this.itemService.getThumbnail(context, item, false);
            if (thumbnail == null) {
                return null;
            }
            return (BitstreamRest)this.converter.toRest(thumbnail.getThumb(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

