/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.core.Context;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionsection")
public class SubmissionPanelRestRepository
extends DSpaceRestRepository<SubmissionSectionRest, String> {
    private SubmissionConfigReader submissionConfigReader = new SubmissionConfigReader();

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionSectionRest findOne(Context context, String id) {
        try {
            SubmissionStepConfig step = this.submissionConfigReader.getStepConfig(id);
            return (SubmissionSectionRest)this.converter.toRest(step, this.utils.obtainProjection());
        }
        catch (SubmissionConfigReaderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionSectionRest> findAll(Context context, Pageable pageable) {
        List subConfs = this.submissionConfigReader.getAllSubmissionConfigs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
        long total = 0L;
        ArrayList<SubmissionStepConfig> stepConfs = new ArrayList<SubmissionStepConfig>();
        for (SubmissionConfig config : subConfs) {
            total = config.getNumberOfSteps();
            for (int i = 0; i < config.getNumberOfSteps(); ++i) {
                SubmissionStepConfig step = config.getStep(i);
                stepConfs.add(step);
            }
        }
        return this.converter.toRestPage(stepConfs, pageable, total, this.utils.obtainProjection());
    }

    @Override
    public Class<SubmissionSectionRest> getDomainClass() {
        return SubmissionSectionRest.class;
    }
}

