/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.DSpaceObjectUtils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class UsageReportRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(UsageReportRestPermissionEvaluatorPlugin.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    private DSpaceObjectUtils dspaceObjectUtil;
    @Autowired
    AuthorizeService authorizeService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission restPermission) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"usagereport", (CharSequence)targetType) || StringUtils.equalsIgnoreCase((CharSequence)"usagereportsearch", (CharSequence)targetType)) {
            Request request = this.requestService.getCurrentRequest();
            Context context = ContextUtil.obtainContext(request.getHttpServletRequest());
            UUID uuidObject = null;
            if (targetId != null) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"usagereport", (CharSequence)targetType)) {
                    if (StringUtils.countMatches((CharSequence)targetId.toString(), (CharSequence)"_") != 1) {
                        throw new IllegalArgumentException("Must end in objectUUID_reportId, example: 1911e8a4-6939-490c-b58b-a5d70f8d91fb_TopCountries");
                    }
                    uuidObject = UUID.fromString(StringUtils.substringBefore((String)targetId.toString(), (String)"_"));
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"usagereportsearch", (CharSequence)targetType)) {
                    uuidObject = UUID.fromString(StringUtils.substringAfterLast((String)targetId.toString(), (String)"/"));
                } else {
                    return false;
                }
                try {
                    DSpaceObject dso = this.dspaceObjectUtil.findDSpaceObject(context, uuidObject);
                    if (dso == null) {
                        throw new ResourceNotFoundException("No DSO found with this UUID: " + uuidObject);
                    }
                    return this.authorizeService.authorizeActionBoolean(context, dso, restPermission.getDspaceApiActionId());
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }
}

