/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dspace.app.rest.model.UploadBitstreamAccessConditionDTO;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.submit.model.AccessConditionOption;
import org.dspace.submit.model.UploadConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitstreamResourcePolicyUtils {
    private static final Logger log = LoggerFactory.getLogger(BitstreamResourcePolicyUtils.class);

    private BitstreamResourcePolicyUtils() {
    }

    public static void findApplyResourcePolicy(Context context, Iterator<UploadConfiguration> uploadConfigs, Bitstream b, List<UploadBitstreamAccessConditionDTO> newAccessConditions) throws SQLException, AuthorizeException, ParseException {
        while (uploadConfigs.hasNext()) {
            UploadConfiguration uploadConfiguration = uploadConfigs.next();
            for (UploadBitstreamAccessConditionDTO newAccessCondition : newAccessConditions) {
                String name = newAccessCondition.getName();
                String description = newAccessCondition.getDescription();
                Date startDate = newAccessCondition.getStartDate();
                Date endDate = newAccessCondition.getEndDate();
                BitstreamResourcePolicyUtils.findApplyResourcePolicy(context, uploadConfiguration, b, name, description, startDate, endDate);
            }
        }
    }

    public static void findApplyResourcePolicy(Context context, UploadConfiguration uploadConfiguration, Bitstream b, String name, String description, Date startDate, Date endDate) throws SQLException, AuthorizeException, ParseException {
        for (AccessConditionOption aco : uploadConfiguration.getOptions()) {
            if (!aco.getName().equalsIgnoreCase(name)) continue;
            aco.createResourcePolicy(context, b, name, description, startDate, endDate);
            return;
        }
    }
}

