/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.RelationshipRestRepositoryIT;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.RelationshipType;
import org.dspace.core.Context;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LeftTiltedRelationshipRestRepositoryIT
extends RelationshipRestRepositoryIT {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.isAuthorOfPublicationRelationshipType.setTilted(RelationshipType.Tilted.LEFT);
        this.relationshipTypeService.update(this.context, (Object)this.isAuthorOfPublicationRelationshipType);
        this.context.restoreAuthSystemState();
    }

    @Override
    @Test
    public void testIsAuthorOfPublicationRelationshipMetadataViaREST() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)this.isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.author1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)String.format("$.metadata['%s.isPublicationOfAuthor']", MetadataSchemaEnum.RELATION.getName()), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.publication1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(String.format("%s.isAuthorOfPublication", MetadataSchemaEnum.RELATION.getName()), this.author1.getID().toString())));
    }
}

