/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RelationshipDeleteRestRepositoryIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EPersonService ePersonService;
    private Item leftItem;
    private Item rightItem;
    private Collection collection;
    private Collection collection2;
    private Collection collection3;
    private Collection collection4;
    private Collection collection5;
    private RelationshipType relationshipType;
    private Relationship relationship;
    private String adminAuthToken;
    private EPerson collectionAdmin;
    private Item personItem;
    private Item projectItem;
    private Item publicationItem;
    private RelationshipType personProjectRelationshipType;
    private RelationshipType publicationPersonRelationshipType;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.adminAuthToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        this.collectionAdmin = this.ePersonService.findByEmail(this.context, "collectionAdminTest@email.com");
        if (this.collectionAdmin == null) {
            this.collectionAdmin = this.ePersonService.create(this.context);
            this.collectionAdmin.setFirstName(this.context, "first");
            this.collectionAdmin.setLastName(this.context, "last");
            this.collectionAdmin.setEmail("collectionAdminTest@email.com");
            this.collectionAdmin.setCanLogIn(true);
            this.collectionAdmin.setLanguage(this.context, I18nUtil.getDefaultLocale().getLanguage());
            this.ePersonService.setPassword(this.collectionAdmin, this.password);
            this.ePersonService.update(this.context, (DSpaceObject)this.collectionAdmin);
        }
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withAdminGroup(new EPerson[]{this.collectionAdmin}).withEntityType("Publication").build();
        this.collection2 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 2").withAdminGroup(new EPerson[]{this.collectionAdmin}).withEntityType("Person").build();
        this.collection3 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 3").withAdminGroup(new EPerson[]{this.collectionAdmin}).withEntityType("JournalIssue").build();
        this.collection4 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 4").withAdminGroup(new EPerson[]{this.collectionAdmin}).withEntityType("JournalVolume").build();
        this.collection5 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 4").withAdminGroup(new EPerson[]{this.collectionAdmin}).withEntityType("Project").build();
        this.context.restoreAuthSystemState();
    }

    @After
    public void destroy() throws Exception {
        try {
            this.context.turnOffAuthorisationSystem();
            this.collectionAdmin = this.ePersonService.findByEmail(this.context, "collectionAdminTest@email.com");
            if (this.collectionAdmin != null) {
                this.ePersonService.delete(this.context, (DSpaceObject)this.collectionAdmin);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.destroy();
    }

    private void initPublicationAuthor() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.leftItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Left item").build();
        this.rightItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection2).withTitle("Right item").withPersonIdentifierFirstName("firstName").withPersonIdentifierLastName("familyName").build();
        this.relationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        this.relationship = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.leftItem, (Item)this.rightItem, (RelationshipType)this.relationshipType).withLeftPlace(0).build();
        this.context.restoreAuthSystemState();
    }

    private void initJournalVolumeIssue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.leftItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection3).withTitle("Left item").withPublicationIssueNumber("2").build();
        this.rightItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection4).withTitle("Right item").withPublicationVolumeNumber("30").build();
        this.relationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "JournalIssue"), this.entityTypeService.findByEntityType(this.context, "JournalVolume"), "isJournalVolumeOfIssue", "isIssueOfJournalVolume");
        this.relationship = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.leftItem, (Item)this.rightItem, (RelationshipType)this.relationshipType).withLeftPlace(0).build();
        this.context.restoreAuthSystemState();
    }

    private void initPersonProjectPublication() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.personItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection2).withTitle("Person 1").withPersonIdentifierFirstName("Donald").withPersonIdentifierLastName("Smith").build();
        this.projectItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection5).withTitle("Project 1").build();
        this.publicationItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Publication 1").build();
        this.personProjectRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Person"), this.entityTypeService.findByEntityType(this.context, "Project"), "isProjectOfPerson", "isPersonOfProject");
        this.publicationPersonRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.personItem, (Item)this.projectItem, (RelationshipType)this.personProjectRelationshipType).withLeftPlace(0).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publicationItem, (Item)this.personItem, (RelationshipType)this.publicationPersonRelationshipType).withLeftPlace(0).build();
        this.context.restoreAuthSystemState();
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToLeftItem() throws Exception {
        this.initPublicationAuthor();
        Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*").size());
        Assert.assertEquals((long)0L, (long)this.leftItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)0L, (long)this.leftItem.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + this.relationship.getID() + "?copyVirtualMetadata=left"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.leftItem = (Item)this.itemService.find(this.context, this.leftItem.getID());
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.leftItem.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        this.rightItem = (Item)this.context.reloadEntity((ReloadableEntity)this.rightItem);
        relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "relation", "isPublicationOfAuthor", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testAuthorDeleteRelationshipCopyToRightItem() throws Exception {
        this.initPublicationAuthor();
        Assert.assertEquals((long)0L, (long)this.rightItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)0L, (long)this.rightItem.getMetadata().stream().filter(metadataValue -> "isPublicationOfAuthor".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + this.relationship.getID() + "?copyVirtualMetadata=right"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.leftItem = (Item)this.itemService.find(this.context, this.leftItem.getID());
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.rightItem = (Item)this.itemService.find(this.context, this.rightItem.getID());
        relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "relation", "isPublicationOfAuthor", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.rightItem.getMetadata().stream().filter(metadataValue -> "isPublicationOfAuthor".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToBothItems() throws Exception {
        this.initPublicationAuthor();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + this.relationship.getID() + "?copyVirtualMetadata=all"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.leftItem = (Item)this.itemService.find(this.context, this.leftItem.getID());
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.leftItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.leftItem.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        this.rightItem = (Item)this.itemService.find(this.context, this.rightItem.getID());
        relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "relation", "isPublicationOfAuthor", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.rightItem.getMetadata().stream().filter(metadataValue -> "isPublicationOfAuthor".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
    }

    @Test
    public void testDeleteJournalRelationshipCopyToLeftItem() throws Exception {
        this.initJournalVolumeIssue();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + this.relationship.getID() + "?copyVirtualMetadata=left"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.leftItem = (Item)this.itemService.find(this.context, this.leftItem.getID());
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        Assert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        this.rightItem = (Item)this.itemService.find(this.context, this.rightItem.getID());
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        Assert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testJournalDeleteRelationshipCopyToRightItem() throws Exception {
        this.initJournalVolumeIssue();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + this.relationship.getID() + "?copyVirtualMetadata=right"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.leftItem = (Item)this.itemService.find(this.context, this.leftItem.getID());
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        Assert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.rightItem = (Item)this.itemService.find(this.context, this.rightItem.getID());
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        Assert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
    }

    @Test
    public void testDeleteJournalRelationshipCopyToBothItems() throws Exception {
        this.initJournalVolumeIssue();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + this.relationship.getID() + "?copyVirtualMetadata=all"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.leftItem = (Item)this.itemService.find(this.context, this.leftItem.getID());
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        Assert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        this.rightItem = (Item)this.itemService.find(this.context, this.rightItem.getID());
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        Assert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
    }

    @Test
    public void deleteItemCopyVirtualMetadataAll() throws Exception {
        this.initPersonProjectPublication();
        for (Item item : Arrays.asList(this.publicationItem, this.projectItem)) {
            Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "author", "*").size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        }
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=all"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertNull((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority());
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.publicationItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.publicationItem.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertNull((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority());
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.projectItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.projectItem.getMetadata().stream().filter(metadataValue -> "isPersonOfProject".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
    }

    @Test
    public void deleteItemCopyVirtualMetadataOneType() throws Exception {
        this.initPersonProjectPublication();
        for (Item item : Arrays.asList(this.publicationItem, this.projectItem)) {
            Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "author", "*").size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        }
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=" + this.publicationPersonRelationshipType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertNull((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority());
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.publicationItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.publicationItem.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void deleteItemCopyVirtualMetadataTwoTypes() throws Exception {
        this.initPersonProjectPublication();
        for (Item item : Arrays.asList(this.publicationItem, this.projectItem)) {
            Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "author", "*").size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        }
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=" + this.publicationPersonRelationshipType.getID() + "&copyVirtualMetadata=" + this.personProjectRelationshipType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertNull((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority());
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.publicationItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.publicationItem.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertNull((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority());
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.projectItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.projectItem.getMetadata().stream().filter(metadataValue -> "isPersonOfProject".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
    }

    @Test
    public void deleteItemCopyVirtualMetadataNone() throws Exception {
        this.initPersonProjectPublication();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void deleteItemCopyVirtualMetadataInvalid() throws Exception {
        this.initPersonProjectPublication();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=" + this.publicationPersonRelationshipType.getID() + "&copyVirtualMetadata=" + this.personProjectRelationshipType.getID() + "&copyVirtualMetadata=SomeThingWrong"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void deleteItemCopyVirtualMetadataAllNoPermissions() throws Exception {
        this.initPersonProjectPublication();
        for (Item item : Arrays.asList(this.publicationItem, this.projectItem)) {
            Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "author", "*").size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        }
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void deleteItemCopyVirtualMetadataAllAsCollectionAdmin() throws Exception {
        this.initPersonProjectPublication();
        this.getClient(this.getAuthToken(this.collectionAdmin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void deleteItemCopyVirtualMetadataTypeAsCollectionAdmin() throws Exception {
        this.initPersonProjectPublication();
        this.getClient(this.getAuthToken(this.collectionAdmin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=" + this.publicationPersonRelationshipType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo(null));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    protected EPerson createOtherCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson otherCollectionAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("other", "col admin").withCanLogin(true).withEmail("otherCollectionAdmin@email.com").withPassword(this.password).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).build();
        Community otherCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Other Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)otherCommunity).withName("Other Collection").withAdminGroup(new EPerson[]{otherCollectionAdmin}).build();
        this.context.restoreAuthSystemState();
        return otherCollectionAdmin;
    }

    @Test
    public void deleteItemCopyVirtualMetadataAllInsufficientPermissions() throws Exception {
        this.initPersonProjectPublication();
        EPerson otherCollectionAdmin = this.createOtherCollectionAdmin();
        this.getClient(this.getAuthToken(otherCollectionAdmin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void deleteItemCopyVirtualMetadataTypeInsufficientPermissions() throws Exception {
        this.initPersonProjectPublication();
        EPerson otherCollectionAdmin = this.createOtherCollectionAdmin();
        this.getClient(this.getAuthToken(otherCollectionAdmin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=" + this.publicationPersonRelationshipType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void deleteItemCopyVirtualMetadataConfigured() throws Exception {
        this.initPersonProjectPublication();
        for (Item item : Arrays.asList(this.publicationItem, this.projectItem)) {
            Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "author", "*").size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
            Assert.assertEquals((long)0L, (long)item.getMetadata().stream().filter(metadataValue -> "isAuthorOfPublication".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
        }
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=configured"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)projectAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertNull((Object)((MetadataValue)projectAuthorList.get(0)).getAuthority());
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertEquals((long)1L, (long)this.projectItem.getMetadata().stream().filter(metadataValue -> "author".equals(metadataValue.getMetadataField().getQualifier())).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.projectItem.getMetadata().stream().filter(metadataValue -> "isPersonOfProject".equals(metadataValue.getMetadataField().getElement())).collect(Collectors.toList()).size());
    }

    @Test
    public void deleteItemCopyVirtualMetadataToCorrectPlace() throws Exception {
        this.initPersonProjectPublication();
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publicationItem, "dc", "contributor", "author", null, "Test Author");
        this.itemService.update(this.context, (DSpaceObject)this.publicationItem);
        this.context.restoreAuthSystemState();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.personItem.getID() + "?copyVirtualMetadata=" + this.publicationPersonRelationshipType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.publicationItem = (Item)this.itemService.find(this.context, this.publicationItem.getID());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)publicationAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"Smith, Donald"));
        Assert.assertNull((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority());
        List publicationRelationships = this.itemService.getMetadata((DSpaceObject)this.publicationItem, "relation", "isAuthorOfPublication", "*", "*");
        Assert.assertThat((Object)publicationRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.projectItem = (Item)this.itemService.find(this.context, this.projectItem.getID());
        List projectAuthorList = this.itemService.getMetadata((DSpaceObject)this.projectItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)projectAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List projectRelationships = this.itemService.getMetadata((DSpaceObject)this.projectItem, "relation", "isPersonOfProject", "*", "*");
        Assert.assertThat((Object)projectRelationships.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }
}

