/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Locale;
import org.dspace.app.rest.matcher.SubmissionFormFieldMatcher;
import org.dspace.app.rest.repository.SubmissionFormRestRepository;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.authority.DCInputAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.dspace.core.service.PluginService;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmissionFormsControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private SubmissionFormRestRepository submissionFormRestRepository;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ChoiceAuthorityService cas;

    @Test
    public void findAll() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.equalTo((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms", (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)6))));
    }

    @Test
    public void findAllWithNewlyCreatedAccountTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.equalTo((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms", (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)6))));
    }

    @Test
    public void findTraditionalPageOne() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/traditionalpageone", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/traditionalpageone", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "Author", null, true, "Add an author", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Title", "You must enter a main title for this item.", false, "Enter the main title of the item.", "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[3].fields", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SubmissionFormFieldMatcher.matchFormFieldDefinition("date", "Date of Issue", "You must enter at least the year.", false, "Please give the date", "col-sm-4", "dc.date.issued"), SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Publisher", null, false, "Enter the name of", "col-sm-8", "dc.publisher")})));
    }

    @Test
    public void findTraditionalPageOneWithNewlyCreatedAccountTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/traditionalpageone", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "Author", null, true, "Add an author", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Title", "You must enter a main title for this item.", false, "Enter the main title of the item.", "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[3].fields", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SubmissionFormFieldMatcher.matchFormFieldDefinition("date", "Date of Issue", "You must enter at least the year.", false, "Please give the date", "col-sm-4", "dc.date.issued"), SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Publisher", null, false, "Enter the name of", "col-sm-8", "dc.publisher")})));
    }

    @Test
    public void findFieldWithAuthorityConfig() throws Exception {
        this.configurationService.setProperty("plugin.named.org.dspace.content.authority.ChoiceAuthority", (Object)new String[]{"org.dspace.content.authority.SolrAuthority = SolrAuthorAuthority", "org.dspace.content.authority.SolrAuthority = SolrEditorAuthority", "org.dspace.content.authority.SolrAuthority = SolrSubjectAuthority"});
        this.configurationService.setProperty("solr.authority.server", (Object)"${solr.server}/authority");
        this.configurationService.setProperty("choices.plugin.dc.contributor.author", (Object)"SolrAuthorAuthority");
        this.configurationService.setProperty("choices.presentation.dc.contributor.author", (Object)"suggest");
        this.configurationService.setProperty("authority.controlled.dc.contributor.author", (Object)"true");
        this.configurationService.setProperty("authority.author.indexer.field.1", (Object)"dc.contributor.author");
        this.configurationService.setProperty("choices.plugin.dc.contributor.editor", (Object)"SolrEditorAuthority");
        this.configurationService.setProperty("choices.presentation.dc.contributor.editor", (Object)"authorLookup");
        this.configurationService.setProperty("authority.controlled.dc.contributor.editor", (Object)"true");
        this.configurationService.setProperty("authority.author.indexer.field.2", (Object)"dc.contributor.editor");
        this.configurationService.setProperty("choices.plugin.dc.subject", (Object)"SolrSubjectAuthority");
        this.configurationService.setProperty("choices.presentation.dc.subject", (Object)"lookup");
        this.configurationService.setProperty("authority.controlled.dc.subject", (Object)"true");
        this.configurationService.setProperty("authority.author.indexer.field.3", (Object)"dc.subject");
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/sampleauthority", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"sampleauthority"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"sampleauthority"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/sampleauthority"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Author", null, true, "Author field that can be associated with an authority providing suggestion", null, "dc.contributor.author", "SolrAuthorAuthority")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("lookup-name", "Editor", null, false, "Editor field that can be associated with an authority providing the special name lookup", null, "dc.contributor.editor", "SolrEditorAuthority")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[2].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("lookup", "Subject", null, true, "Subject field that can be associated with an authority providing lookup", null, "dc.subject", "SolrSubjectAuthority"))));
        this.configurationService.reloadConfig();
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
    }

    @Test
    public void findFieldWithValuePairsConfig() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/traditionalpageone", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[7].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("dropdown", "Type", null, true, "Select the type(s) of content of the item. To select more than one value in the list, you may have to hold down the \"CTRL\" or \"Shift\" key.", null, "dc.type", "common_types"))));
    }

    @Test
    public void findOpenRelationshipConfig() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/traditionalpageone", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormOpenRelationshipFieldDefinition("name", "Author", null, true, "Add an author", "dc.contributor.author", "isAuthorOfPublication", null, "person", true))));
    }

    @Test
    public void findClosedRelationshipConfig() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/journalVolumeStep", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"journalVolumeStep"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"journalVolumeStep"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/journalVolumeStep"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormClosedRelationshipFieldDefinition("Journal", null, false, "Select the journal related to this volume.", "isJournalOfVolume", "creativework.publisher:somepublishername", "periodical", false))));
    }

    @Test
    public void languageSupportTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String[] supportedLanguage = new String[]{"it", "uk"};
        this.configurationService.setProperty("default.locale", (Object)"it");
        this.configurationService.setProperty("webui.supported.locales", (Object)supportedLanguage);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
        Locale uk = new Locale("uk");
        Locale it = new Locale("it");
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/languagetest", (Object[])new Object[0]).locale(it)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "Autore", "\u00c8 richiesto almeno un autore", true, "Aggiungi un autore", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Titolo", "\u00c8 necessario inserire un titolo principale per questo item", false, "Inserisci titolo principale di questo item", "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[2].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("dropdown", "Lingua", null, false, "Selezionare la lingua del contenuto principale dell'item. Se la lingua non compare nell'elenco, selezionare (Altro). Se il contenuto non ha davvero una lingua (ad esempio, se \u00e8 un set di dati o un'immagine) selezionare (N/A)", null, "dc.language.iso", "common_iso_languages"))));
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/languagetest", (Object[])new Object[0]).locale(uk)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "\u0410\u0432\u0442\u043e\u0440", "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u0432\u0432\u0435\u0441\u0442\u0438 \u0445\u043e\u0447\u0430\u0431 \u043e\u0434\u043d\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0440\u0430!", true, "\u0414\u043e\u0434\u0430\u0442\u0438 \u0430\u0432\u0442\u043e\u0440\u0430", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", "\u0417\u0430\u0433\u043e\u0432\u043e\u043b\u043e\u043a \u0444\u0430\u0439\u043b\u0430 \u043e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0438\u0439 !", false, "\u0412\u0432\u0435\u0441\u0442\u0438 \u043e\u0441\u043d\u043e\u0432\u043d\u0438\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0444\u0430\u0439\u043b\u0430", "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[2].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("dropdown", "\u041c\u043e\u0432\u0430", null, false, "\u0412\u0438\u0431\u0435\u0440i\u0442\u044c \u043c\u043e\u0432\u0443 \u0433\u043e\u043b\u043e\u0432\u043d\u043e\u0433\u043e \u0437\u043ci\u0441\u0442\u0443 \u0444\u0430\u0439\u043b\u0443, \u044f\u043a \u0449\u043e \u043c\u043e\u0432\u0438 \u043d\u0435\u043c\u0430\u0454 \u0443 \u0441\u043f\u0438\u0441\u043a\u0443, \u0432\u0438\u0431\u0440\u0430\u0442\u0438 (I\u043d\u0448\u0430). \u042f\u043a \u0449\u043e \u0432\u043ci\u0441\u0442 \u0432\u0430\u0439\u043b\u0443 \u043d\u0435 \u0454 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u0438\u043c, \u043d\u0430\u043f\u0440\u0438\u043a\u043b\u0430\u0434 \u0454 \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444i\u0454\u044e, \u0442\u043e\u0434i \u0432\u0438\u0431\u0440\u0430\u0442\u0438 (N/A)", null, "dc.language.iso", "common_iso_languages"))));
        this.resetLocalesConfiguration();
    }

    @Test
    public void preferLanguageTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String[] supportedLanguage = new String[]{"it", "uk"};
        this.configurationService.setProperty("default.locale", (Object)"it");
        this.configurationService.setProperty("webui.supported.locales", (Object)supportedLanguage);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
        EPerson epersonIT = EPersonBuilder.createEPerson((Context)this.context).withEmail("epersonIT@example.com").withPassword(this.password).withLanguage("it").build();
        EPerson epersonUK = EPersonBuilder.createEPerson((Context)this.context).withEmail("epersonUK@example.com").withPassword(this.password).withLanguage("uk").build();
        this.context.restoreAuthSystemState();
        String tokenEpersonIT = this.getAuthToken(epersonIT.getEmail(), this.password);
        String tokenEpersonUK = this.getAuthToken(epersonUK.getEmail(), this.password);
        this.getClient(tokenEpersonIT).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/languagetest", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "Autore", "\u00c8 richiesto almeno un autore", true, "Aggiungi un autore", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Titolo", "\u00c8 necessario inserire un titolo principale per questo item", false, "Inserisci titolo principale di questo item", "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[2].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("dropdown", "Lingua", null, false, "Selezionare la lingua del contenuto principale dell'item. Se la lingua non compare nell'elenco, selezionare (Altro). Se il contenuto non ha davvero una lingua (ad esempio, se \u00e8 un set di dati o un'immagine) selezionare (N/A)", null, "dc.language.iso", "common_iso_languages"))));
        this.getClient(tokenEpersonUK).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/languagetest", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "\u0410\u0432\u0442\u043e\u0440", "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u0432\u0432\u0435\u0441\u0442\u0438 \u0445\u043e\u0447\u0430\u0431 \u043e\u0434\u043d\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0440\u0430!", true, "\u0414\u043e\u0434\u0430\u0442\u0438 \u0430\u0432\u0442\u043e\u0440\u0430", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", "\u0417\u0430\u0433\u043e\u0432\u043e\u043b\u043e\u043a \u0444\u0430\u0439\u043b\u0430 \u043e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0438\u0439 !", false, "\u0412\u0432\u0435\u0441\u0442\u0438 \u043e\u0441\u043d\u043e\u0432\u043d\u0438\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0444\u0430\u0439\u043b\u0430", "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[2].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("dropdown", "\u041c\u043e\u0432\u0430", null, false, "\u0412\u0438\u0431\u0435\u0440i\u0442\u044c \u043c\u043e\u0432\u0443 \u0433\u043e\u043b\u043e\u0432\u043d\u043e\u0433\u043e \u0437\u043ci\u0441\u0442\u0443 \u0444\u0430\u0439\u043b\u0443, \u044f\u043a \u0449\u043e \u043c\u043e\u0432\u0438 \u043d\u0435\u043c\u0430\u0454 \u0443 \u0441\u043f\u0438\u0441\u043a\u0443, \u0432\u0438\u0431\u0440\u0430\u0442\u0438 (I\u043d\u0448\u0430). \u042f\u043a \u0449\u043e \u0432\u043ci\u0441\u0442 \u0432\u0430\u0439\u043b\u0443 \u043d\u0435 \u0454 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u0438\u043c, \u043d\u0430\u043f\u0440\u0438\u043a\u043b\u0430\u0434 \u0454 \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444i\u0454\u044e, \u0442\u043e\u0434i \u0432\u0438\u0431\u0440\u0430\u0442\u0438 (N/A)", null, "dc.language.iso", "common_iso_languages"))));
        this.resetLocalesConfiguration();
    }

    @Test
    public void userChoiceAnotherLanguageTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String[] supportedLanguage = new String[]{"it", "uk"};
        this.configurationService.setProperty("default.locale", (Object)"it");
        this.configurationService.setProperty("webui.supported.locales", (Object)supportedLanguage);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
        Locale it = new Locale("it");
        EPerson epersonUK = EPersonBuilder.createEPerson((Context)this.context).withEmail("epersonUK@example.com").withPassword(this.password).withLanguage("uk").build();
        this.context.restoreAuthSystemState();
        String tokenEpersonUK = this.getAuthToken(epersonUK.getEmail(), this.password);
        this.getClient(tokenEpersonUK).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/languagetest", (Object[])new Object[0]).locale(it)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "Autore", "\u00c8 richiesto almeno un autore", true, "Aggiungi un autore", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Titolo", "\u00c8 necessario inserire un titolo principale per questo item", false, "Inserisci titolo principale di questo item", "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[2].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("dropdown", "Lingua", null, false, "Selezionare la lingua del contenuto principale dell'item. Se la lingua non compare nell'elenco, selezionare (Altro). Se il contenuto non ha davvero una lingua (ad esempio, se \u00e8 un set di dati o un'immagine) selezionare (N/A)", null, "dc.language.iso", "common_iso_languages"))));
        this.resetLocalesConfiguration();
    }

    @Test
    public void defaultLanguageTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String[] supportedLanguage = new String[]{"it", "uk"};
        this.configurationService.setProperty("default.locale", (Object)"it");
        this.configurationService.setProperty("webui.supported.locales", (Object)supportedLanguage);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/languagetest", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "Autore", "\u00c8 richiesto almeno un autore", true, "Aggiungi un autore", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Titolo", "\u00c8 necessario inserire un titolo principale per questo item", false, "Inserisci titolo principale di questo item", "dc.title"))));
        this.resetLocalesConfiguration();
    }

    @Test
    public void supportLanguageUsingMultipleLocaleTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String[] supportedLanguage = new String[]{"it", "uk", "en"};
        this.configurationService.setProperty("default.locale", (Object)"en");
        this.configurationService.setProperty("webui.supported.locales", (Object)supportedLanguage);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/languagetest", (Object[])new Object[0]).header("Accept-Language", new Object[]{"fr;q=1, it;q=0.9"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("name", "Autore", "\u00c8 richiesto almeno un autore", true, "Aggiungi un autore", "dc.contributor.author")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[1].fields", (Matcher)Matchers.contains(SubmissionFormFieldMatcher.matchFormFieldDefinition("onebox", "Titolo", "\u00c8 necessario inserire un titolo principale per questo item", false, "Inserisci titolo principale di questo item", "dc.title"))));
        this.resetLocalesConfiguration();
    }

    @Test
    public void multipleExternalSourcesTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/traditionalpageone", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields[0].selectableRelationship.externalSources", (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.is((Object)"orcid"), Matchers.is((Object)"my_staff_db")})));
    }

    @Test
    public void noExternalSourcesTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms/journalVolumeStep", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"journalVolumeStep"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"journalVolumeStep"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissionform"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/config/submissionforms/journalVolumeStep"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rows[0].fields[0].selectableRelationship.externalSources", (Matcher)Matchers.nullValue()));
    }

    private void resetLocalesConfiguration() throws DCInputsReaderException {
        this.configurationService.setProperty("default.locale", (Object)"en");
        this.configurationService.setProperty("webui.supported.locales", null);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"0"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms[0].id", (Matcher)Matchers.is((Object)"bitstream-metadata"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms[1].id", (Matcher)Matchers.is((Object)"journalVolumeStep"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.equalTo((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms[0].id", (Matcher)Matchers.is((Object)"languagetest"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms[1].id", (Matcher)Matchers.is((Object)"traditionalpagetwo"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.equalTo((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissionforms", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms[0].id", (Matcher)Matchers.is((Object)"sampleauthority"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submissionforms[1].id", (Matcher)Matchers.is((Object)"traditionalpageone"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/config/submissionforms?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.equalTo((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2)));
    }
}

