/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.ResourcePolicyMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class WorkspaceItemRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private CollectionService cs;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ConfigurationService configurationService;
    private GroupService groupService;
    private ResourcePolicyService resourcePolicyService;
    private Group embargoedGroups;
    private Group embargoedGroup1;
    private Group embargoedGroup2;
    private Group anonymousGroup;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
        this.embargoedGroups = GroupBuilder.createGroup((Context)this.context).withName("Embargoed Groups").build();
        this.embargoedGroup1 = GroupBuilder.createGroup((Context)this.context).withName("Embargoed Group 1").withParent(this.embargoedGroups).build();
        this.embargoedGroup2 = GroupBuilder.createGroup((Context)this.context).withName("Embargoed Group 2").withParent(this.embargoedGroups).build();
        this.anonymousGroup = EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous");
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllTest() throws Exception {
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2016-02-13").build();
        WorkspaceItem workspaceItem3 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 3").withIssueDate("2016-02-13").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2017-10-17"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2016-02-13"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workspace Item 3", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/submission/workspaceitems"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAllUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2020-11-13").build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2019-09-13").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-01-13").build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2018-09-20").build();
        this.context.restoreAuthSystemState();
        String authTokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authTokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2019-01-13"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2018-09-20")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/submission/workspaceitems"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllWithPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2016-02-13").build();
        WorkspaceItem workspaceItem3 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 3").withIssueDate("2016-02-13").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2017-10-17"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workspace Item 3", "2016-02-13")))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.contains((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workspace Item 3", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2017-10-17"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2016-02-13")})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-09-09").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenEperson1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workspace Item 1", "2019-09-09", "ExtraEntry"))));
        String tokenEperson2 = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(tokenEperson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID() + "/collection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID() + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(witem.getItem(), "Workspace Item 1", "2017-10-17"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID() + "/submissionDefinition"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditional")))));
    }

    @Test
    public void findOneWrongUUIDTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").build();
        Item item = witem.getItem();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/biststreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void deleteOneUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-01-01").build();
        Item item = witem.getItem();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter1@example.com").withPassword("qwerty01").build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter2@example.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{submitter1, submitter2}).build();
        this.context.setCurrentUser(submitter1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2020-01-01").build();
        Item item = witem.getItem();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.setCurrentUser(submitter2);
        WorkspaceItem witem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 2").withIssueDate("2020-02-02").build();
        Item item2 = witem2.getItem();
        String bitstreamContent2 = "ThisIsSomeDummyText2";
        Bitstream bitstream2 = null;
        try (InputStream is2 = IOUtils.toInputStream((String)bitstreamContent2, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)item2, (InputStream)is2).withName("Bitstream 2").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String tokenSubmitter2 = this.getAuthToken(submitter2.getEmail(), "qwerty02");
        this.getClient(tokenSubmitter2).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findBySubmitterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter1@example.com").withPassword("qwerty01").build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter2@example.com").withPassword("qwerty02").build();
        this.context.setCurrentUser(submitter1);
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2016-02-13").build();
        this.context.setCurrentUser(submitter2);
        WorkspaceItem workspaceItem3 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 3").withIssueDate("2016-02-13").build();
        this.context.restoreAuthSystemState();
        String tokenSubmitter1 = this.getAuthToken(submitter1.getEmail(), "qwerty01");
        this.getClient(tokenSubmitter1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"20"}).param("uuid", new String[]{submitter1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2017-10-17"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workspace Item 3", "2016-02-13"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenSubmitter1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"}).param("uuid", new String[]{submitter1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.contains((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2017-10-17"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workspace Item 3", "2016-02-13")})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        String tokenSubmitter2 = this.getAuthToken(submitter2.getEmail(), "qwerty02");
        this.getClient(tokenSubmitter2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"20"}).param("uuid", new String[]{submitter2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.contains((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workspace Item 3", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("uuid", new String[]{submitter1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2017-10-17"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findBySubmitterForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter1@example.com").withPassword("qwerty01").build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter2@example.com").withPassword("qwerty02").build();
        this.context.setCurrentUser(submitter1);
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-10-17").build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 2").withIssueDate("2018-02-13").build();
        this.context.restoreAuthSystemState();
        String tokenSubmitter1 = this.getAuthToken(submitter1.getEmail(), "qwerty01");
        this.getClient(tokenSubmitter1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("uuid", new String[]{submitter1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workspace Item 1", "2019-10-17"), WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workspace Item 2", "2018-02-13")})));
        String tokenSubmitter2 = this.getAuthToken(submitter2.getEmail(), "qwerty02");
        this.getClient(tokenSubmitter2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("uuid", new String[]{submitter1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createEmptyWorkspateItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef1 = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        AtomicReference idRef3 = new AtomicReference();
        try {
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("owningCollection", new String[]{col1.getID().toString()}).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("owningCollection", new String[]{col2.getID().toString()}).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection.id", (Matcher)Matchers.is((Object)col2.getID().toString()))).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", WorkspaceItemMatcher.matchFullEmbeds())).andDo(result -> idRef3.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            WorkspaceItemBuilder.deleteWorkspaceItem((Integer)((Integer)idRef1.get()));
            WorkspaceItemBuilder.deleteWorkspaceItem((Integer)((Integer)idRef2.get()));
            WorkspaceItemBuilder.deleteWorkspaceItem((Integer)((Integer)idRef3.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromBibtexFileWithOneEntryTest() throws Exception {
        int i;
        Iterator iterator;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "/local/path/bibtex-test.bib", "application/x-bibtex", bibtex);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(bibtexFile).param("owningCollection", new String[]{col2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        bibtex.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromCSVWithOneEntryTest() throws Exception {
        int i;
        Iterator iterator;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream csv = ((Object)((Object)this)).getClass().getResourceAsStream("csv-test.csv");
        MockMultipartFile csvFile = new MockMultipartFile("file", "/local/path/csv-test.csv", "text/csv", csv);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(csvFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Nobody"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)"2006"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.issn'][0].value", (Matcher)Matchers.is((Object)"Mock ISSN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.type'][0].value", (Matcher)Matchers.is((Object)"Mock subtype"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/csv-test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"csv-test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(csvFile).param("owningCollection", new String[]{col2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Nobody"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)"2006"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.issn'][0].value", (Matcher)Matchers.is((Object)"Mock ISSN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.type'][0].value", (Matcher)Matchers.is((Object)"Mock subtype"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/csv-test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"csv-test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        csv.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromCSVWithOneEntryAndMissingDataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream csv = ((Object)((Object)this)).getClass().getResourceAsStream("csv-missing-field-test.csv");
        MockMultipartFile csvFile = new MockMultipartFile("file", "/local/path/csv-missing-field-test.csv", "text/csv", csv);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(csvFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Nobody"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][1].value", (Matcher)Matchers.is((Object)"Try escape, in item"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.date.issued'][0].value", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.issn'][0].value", (Matcher)Matchers.is((Object)"Mock ISSN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.type'][0].value", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/csv-missing-field-test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"csv-missing-field-test.csv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                Iterator iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        csv.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromTSVWithOneEntryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream tsv = ((Object)((Object)this)).getClass().getResourceAsStream("tsv-test.tsv");
        MockMultipartFile tsvFile = new MockMultipartFile("file", "/local/path/tsv-test.tsv", "text/tsv", tsv);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(tsvFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Nobody"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)"2006"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.issn'][0].value", (Matcher)Matchers.is((Object)"Mock ISSN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.type'][0].value", (Matcher)Matchers.is((Object)"Mock subtype"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/tsv-test.tsv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"tsv-test.tsv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                Iterator iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        tsv.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromRISWithOneEntryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream ris = ((Object)((Object)this)).getClass().getResourceAsStream("ris-test.ris");
        MockMultipartFile tsvFile = new MockMultipartFile("file", "/local/path/ris-test.ris", "text/ris", ris);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(tsvFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"Challenge\u2013Response Identification"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][1].value", (Matcher)Matchers.is((Object)"Challenge\u2013Response Identification second title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Just, Mike"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)"2005"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.issn'][0].value", (Matcher)Matchers.is((Object)"978-0-387-23483-0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.type'][0].value", (Matcher)Matchers.is((Object)"Mock subtype"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/ris-test.ris"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"ris-test.ris"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                Iterator iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        ris.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromEndnoteWithOneEntryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream endnote = ((Object)((Object)this)).getClass().getResourceAsStream("endnote-test.enw");
        MockMultipartFile endnoteFile = new MockMultipartFile("file", "/local/path/endnote-test.enw", "text/endnote", endnote);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(endnoteFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Author 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][1].value", (Matcher)Matchers.is((Object)"Author 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)"2005"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpagetwo['dc.description.abstract'][0].value", (Matcher)Matchers.is((Object)"This is my abstract"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/endnote-test.enw"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"endnote-test.enw"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                Iterator iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        endnote.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromTSVWithOneEntryAndMissingDataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream tsv = ((Object)((Object)this)).getClass().getResourceAsStream("tsv-missing-field-test.tsv");
        MockMultipartFile csvFile = new MockMultipartFile("file", "/local/path/tsv-missing-field-test.tsv", "text/tsv", tsv);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(csvFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Nobody"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][1].value", (Matcher)Matchers.is((Object)"Try escape \t\t\tin \t\titem"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.date.issued'][0].value", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.issn'][0].value", (Matcher)Matchers.is((Object)"Mock ISSN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.type'][0].value", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/tsv-missing-field-test.tsv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"tsv-missing-field-test.tsv"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[*]._embedded.upload", (Object[])new Object[0]).doesNotExist()).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                Iterator iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        tsv.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingleWorkspaceItemFromMultipleFilesWithOneEntryTest() throws Exception {
        int i;
        Iterator iterator;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "/local/path/bibtex-test.bib", "application/x-bibtex", bibtex);
        InputStream xmlIS = ((Object)((Object)this)).getClass().getResourceAsStream("pubmed-test.xml");
        MockMultipartFile pubmedFile = new MockMultipartFile("file", "/local/path/pubmed-test.xml", "application/xml", xmlIS);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(bibtexFile).file(pubmedFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][1].value", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[1].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/pubmed-test.xml"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[1].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"pubmed-test.xml"))).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(bibtexFile).file(pubmedFile).param("owningCollection", new String[]{col2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0]._embedded.collection.id", (Matcher)Matchers.is((Object)col2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][1].value", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[1].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/pubmed-test.xml"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[1].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"pubmed-test.xml"))).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        bibtex.close();
        xmlIS.close();
    }

    @Test
    public void createSingleWorkspaceItemsFromSingleFileWithMultipleEntriesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test-3-entries.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "bibtex-test-3-entries.bib", "application/x-bibtex", bibtex);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().is(422));
        bibtex.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createPubmedWorkspaceItemFromFileTest() throws Exception {
        int i;
        Iterator iterator;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        InputStream xmlIS = ((Object)((Object)this)).getClass().getResourceAsStream("pubmed-test.xml");
        MockMultipartFile pubmedFile = new MockMultipartFile("file", "/local/path/pubmed-test.xml", "application/xml", xmlIS);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(pubmedFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"Multistep microreactions with proteins using electrocapture technology."))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"15117179"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Astorga-Wells, Juan"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/pubmed-test.xml"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"pubmed-test.xml"))).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(pubmedFile).param("owningCollection", new String[]{col2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"Multistep microreactions with proteins using electrocapture technology."))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"15117179"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Astorga-Wells, Juan"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/pubmed-test.xml"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"pubmed-test.xml"))).andDo(result -> idRef.set((List)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[*].id", (Predicate[])new Predicate[0])));
        }
        finally {
            if (idRef != null && idRef.get() != null) {
                iterator = ((List)idRef.get()).iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    WorkspaceItemBuilder.deleteWorkspaceItem((Integer)i);
                }
            }
        }
        xmlIS.close();
    }

    @Test
    public void createWorkspaceItemFromPDFFileTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        MockMultipartFile pdfFile = new MockMultipartFile("file", "/local/path/myfile.pdf", "application/pdf", pdf);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(pdfFile)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"myfile.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems[0].sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/myfile.pdf")));
        pdf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void validationErrorsRequiredMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 2").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist());
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.required')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.date.issued")))))));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("owningCollection", new String[]{col1.getID().toString()}).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.required')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.title")), JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.date.issued"))}))))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            WorkspaceItemBuilder.deleteWorkspaceItem((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void patchUpdateMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void patchUpdateMetadataForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-01-01").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> updateIssueDate = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "2020-01-01");
        updateIssueDate.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.date.issued/0", value));
        String patchBody = this.getPatchContent(updateIssueDate);
        String tokenEperson2 = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(tokenEperson2).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenEperson1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2019-01-01", "ExtraEntry"))));
    }

    public void patchReplaceMetadataOnItemStillInSubmissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(this.eperson);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/metadata/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        UUID idItem = witem.getItem().getID();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + idItem), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + idItem), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(witem.getItem(), "Workspace Item 1", "2017-10-17"))));
    }

    @Test
    public void patchAddMetadataOnItemStillInSubmissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(this.eperson);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> addIssueDate = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "2017-10-17");
        addIssueDate.add((Operation)new ReplaceOperation("/metadata/dc.date.issued/0", value));
        String patchBody = this.getPatchContent(addIssueDate);
        UUID idItem = witem.getItem().getID();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + idItem), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + idItem), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", "Workspace")})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata.['dc.date.issued']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void patchUpdateMetadataUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-01-01").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> updateIssueDate = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "2020-01-01");
        updateIssueDate.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.date.issued/0", value));
        String patchBody = this.getPatchContent(updateIssueDate);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String tokenEperson1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2019-01-01", "ExtraEntry"))));
    }

    @Test
    public void patchRemoveMetadataOnItemStillInSubmissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(this.eperson);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace title").withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> removeTitle = new ArrayList<Operation>();
        removeTitle.add((Operation)new RemoveOperation("/metadata/dc.title/0"));
        String patchBody = this.getPatchContent(removeTitle);
        UUID idItem = witem.getItem().getID();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + idItem), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + idItem), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.title", "Workspace title"), MetadataMatcher.matchMetadata("dc.date.issued", "2017-10-17")))));
    }

    @Test
    public void patchDeleteMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        WorkspaceItem witemMultipleSubjects = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("Subject1").withSubject("Subject2").withSubject("Subject3").withSubject("Subject4").build();
        WorkspaceItem witemWithTitleDateAndSubjects = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("Subject1").withSubject("Subject2").withSubject("Subject3").withSubject("Subject4").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> removeTitle = new ArrayList<Operation>();
        removeTitle.add((Operation)new RemoveOperation("/sections/traditionalpageone/dc.title/0"));
        String patchBody = this.getPatchContent(removeTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.required')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.title"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, null, "2017-10-17", "ExtraEntry"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.required')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.title"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, null, "2017-10-17", "ExtraEntry"))));
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        ArrayList<Operation> removeMidSubject = new ArrayList<Operation>();
        removeMidSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/1"));
        patchBody = this.getPatchContent(removeMidSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject4")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject4")));
        ArrayList<Operation> removeFirstSubject = new ArrayList<Operation>();
        removeFirstSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/0"));
        patchBody = this.getPatchContent(removeFirstSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject4")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject4")));
        ArrayList<Operation> removeLastSubject = new ArrayList<Operation>();
        removeLastSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/1"));
        patchBody = this.getPatchContent(removeLastSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3")));
        ArrayList<Operation> removeFinalSubject = new ArrayList<Operation>();
        removeFinalSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/0"));
        patchBody = this.getPatchContent(removeFinalSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
        ArrayList<Operation> removeSubjectsAllAtOnce = new ArrayList<Operation>();
        removeSubjectsAllAtOnce.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject"));
        patchBody = this.getPatchContent(removeSubjectsAllAtOnce);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witemWithTitleDateAndSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witemWithTitleDateAndSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void patchDeleteMetadataForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-01-01").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> deleteIssueDate = new ArrayList<Operation>();
        deleteIssueDate.add((Operation)new RemoveOperation("/sections/traditionalpageone/dc.date.issued/0"));
        String patchBody = this.getPatchContent(deleteIssueDate);
        String tokenEperson2 = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(tokenEperson2).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenEperson1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2019-01-01", "ExtraEntry"))));
    }

    @Test
    public void patchDeleteMetadataUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2019-01-01").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> deleteIssueDate = new ArrayList<Operation>();
        deleteIssueDate.add((Operation)new RemoveOperation("/sections/traditionalpageone/dc.date.issued/0"));
        String patchBody = this.getPatchContent(deleteIssueDate);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String tokenEperson1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2019-01-01", "ExtraEntry"))));
    }

    @Test
    public void patchAddMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        ArrayList titelValues = new ArrayList();
        ArrayList uriValues = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        HashMap<String, String> value2 = new HashMap<String, String>();
        value.put("value", "New Title");
        value2.put("value", "https://www.dspace.org");
        titelValues.add(value);
        uriValues.add(value2);
        operations.add((Operation)new AddOperation("/sections/traditionalpageone/dc.title", titelValues));
        operations.add((Operation)new AddOperation("/sections/traditionalpageone/dc.identifier.uri", uriValues));
        String patchBody = this.getPatchContent(operations);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.sections.traditionalpageone['dc.identifier.uri'][0].value", (Matcher)Matchers.is((Object)"https://www.dspace.org"))})));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.sections.traditionalpageone['dc.identifier.uri'][0].value", (Matcher)Matchers.is((Object)"https://www.dspace.org"))})));
    }

    @Test
    public void patchAddMetadataUpdateExistValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> addTitle = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        values.add(value);
        addTitle.add((Operation)new AddOperation("/sections/traditionalpageone/dc.title", values));
        String patchBody = this.getPatchContent(addTitle);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void patchAddMetadataUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2020-01-13").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> addTitle = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        values.add(value);
        addTitle.add((Operation)new AddOperation("/sections/traditionalpageone/dc.title", values));
        String patchBody = this.getPatchContent(addTitle);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, null, "2020-01-13", "ExtraEntry"))));
    }

    @Test
    public void patchAddMetadataForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2019-11-25").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> addTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        addTitle.add((Operation)new AddOperation("/sections/traditionalpageone/dc.title", value));
        String patchBody = this.getPatchContent(addTitle);
        String tokenEperson2 = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(tokenEperson2).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenEperson1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, null, "2019-11-25", "ExtraEntry"))));
    }

    @Test
    public void patchAddMultipleMetadataValuesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        ArrayList<Operation> addSubjects = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value1 = new HashMap<String, String>();
        value1.put("value", "Subject1");
        HashMap<String, String> value2 = new HashMap<String, String>();
        value2.put("value", "Subject2");
        values.add(value1);
        values.add(value2);
        addSubjects.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject", values));
        String patchBody = this.getPatchContent(addSubjects);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject2")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject2")));
        ArrayList<Operation> addFirstSubject = new ArrayList<Operation>();
        HashMap<String, String> firstSubject = new HashMap<String, String>();
        firstSubject.put("value", "First Subject");
        addFirstSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/0", firstSubject));
        patchBody = this.getPatchContent(addFirstSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject2")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject2")));
        ArrayList<Operation> addMidSubject = new ArrayList<Operation>();
        HashMap<String, String> midSubject = new HashMap<String, String>();
        midSubject.put("value", "Mid Subject");
        addMidSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/2", midSubject));
        patchBody = this.getPatchContent(addMidSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2")));
        ArrayList<Operation> addLastSubject = new ArrayList<Operation>();
        HashMap<String, String> lastSubject = new HashMap<String, String>();
        lastSubject.put("value", "Last Subject");
        addLastSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/4", lastSubject));
        patchBody = this.getPatchContent(addLastSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject")));
        ArrayList<Operation> addFinalSubject = new ArrayList<Operation>();
        HashMap<String, String> finalSubject = new HashMap<String, String>();
        finalSubject.put("value", "Final Subject");
        addFinalSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/-", finalSubject));
        patchBody = this.getPatchContent(addFinalSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][5].value", (Matcher)Matchers.is((Object)"Final Subject")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][5].value", (Matcher)Matchers.is((Object)"Final Subject")));
    }

    @Test
    public void patchAcceptLicenseTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").build();
        WorkspaceItem witem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem 2").withIssueDate("2017-10-17").build();
        WorkspaceItem witem3 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem 3").withIssueDate("2017-10-17").build();
        WorkspaceItem witem4 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem 4").withIssueDate("2017-10-17").build();
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        ArrayList<Operation> addGrant = new ArrayList<Operation>();
        addGrant.add((Operation)new AddOperation("/sections/license/granted", (Object)true));
        String patchBody = this.getPatchContent(addGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        ArrayList<Operation> addGrantString = new ArrayList<Operation>();
        addGrantString.add((Operation)new AddOperation("/sections/license/granted", (Object)"true"));
        patchBody = this.getPatchContent(addGrantString);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        ArrayList<Operation> replaceGrant = new ArrayList<Operation>();
        replaceGrant.add((Operation)new ReplaceOperation("/sections/license/granted", (Object)true));
        patchBody = this.getPatchContent(replaceGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem3.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        ArrayList replaceGrantString = new ArrayList();
        replaceGrant.add((Operation)new ReplaceOperation("/sections/license/granted", (Object)"true"));
        patchBody = this.getPatchContent(replaceGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem4.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem4.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
    }

    @Test
    public void patchRejectLicenseTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").grantLicense().build();
        WorkspaceItem witem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem 2").withIssueDate("2017-10-17").grantLicense().build();
        WorkspaceItem witem3 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem 3").withIssueDate("2017-10-17").grantLicense().build();
        WorkspaceItem witem4 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem 4").withIssueDate("2017-10-17").grantLicense().build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isNotEmpty());
        ArrayList<Operation> addGrant = new ArrayList<Operation>();
        addGrant.add((Operation)new AddOperation("/sections/license/granted", (Object)false));
        String patchBody = this.getPatchContent(addGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        ArrayList<Operation> addGrantString = new ArrayList<Operation>();
        addGrantString.add((Operation)new AddOperation("/sections/license/granted", (Object)"false"));
        patchBody = this.getPatchContent(addGrantString);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        ArrayList<Operation> replaceGrant = new ArrayList<Operation>();
        replaceGrant.add((Operation)new ReplaceOperation("/sections/license/granted", (Object)false));
        patchBody = this.getPatchContent(replaceGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem3.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        ArrayList replaceGrantString = new ArrayList();
        replaceGrant.add((Operation)new ReplaceOperation("/sections/license/granted", (Object)"false"));
        patchBody = this.getPatchContent(replaceGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem4.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem4.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.granted", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.acceptanceDate", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.license.url", (Object[])new Object[0]).isEmpty());
    }

    @Test
    public void patchUploadTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/simple-article.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"simple-article.pdf")));
        ArrayList<Operation> addOpts = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "newfilename.pdf");
        HashMap<String, String> valueDesc = new HashMap<String, String>();
        valueDesc.put("value", "Description");
        ArrayList<HashMap<String, String>> valueDescs = new ArrayList<HashMap<String, String>>();
        valueDescs.add(valueDesc);
        addOpts.add((Operation)new AddOperation("/sections/upload/files/0/metadata/dc.title/0", value));
        addOpts.add((Operation)new AddOperation("/sections/upload/files/0/metadata/dc.description", valueDescs));
        String patchBody = this.getPatchContent(addOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/simple-article.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"newfilename.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.description'][0].value", (Matcher)Matchers.is((Object)"Description")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/simple-article.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"newfilename.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.description'][0].value", (Matcher)Matchers.is((Object)"Description")));
        ArrayList<Operation> removeOpts = new ArrayList<Operation>();
        removeOpts.add((Operation)new RemoveOperation("/sections/upload/files/0/metadata/dc.description"));
        patchBody = this.getPatchContent(removeOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"newfilename.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.description']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/simple-article.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"newfilename.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.description']", (Object[])new Object[0]).doesNotExist());
        ArrayList<Operation> updateOpts = new ArrayList<Operation>();
        HashMap<String, String> updateValue = new HashMap<String, String>();
        updateValue.put("value", "another-filename.pdf");
        updateOpts.add((Operation)new ReplaceOperation("/sections/upload/files/0/metadata/dc.title/0", updateValue));
        patchBody = this.getPatchContent(updateOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"another-filename.pdf")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"another-filename.pdf")));
    }

    @Test
    public void patchUploadAddAndRemoveAccessConditionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection collection1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection1).withTitle("Test WorkspaceItem").withIssueDate("2019-10-01").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = new Date();
        String startDateStr = dateFmt.format(startDate);
        ArrayList<Operation> addAccessCondition = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("name", "embargo");
        value.put("startDate", startDateStr);
        addAccessCondition.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", value));
        String patchBody = this.getPatchContent(addAccessCondition);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"embargo"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.is((Object)startDateStr))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"embargo"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.is((Object)startDateStr))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
        ArrayList<Operation> removeAccessCondition = new ArrayList<Operation>();
        removeAccessCondition.add((Operation)new RemoveOperation("/sections/upload/files/0/accessConditions"));
        String patchReplaceBody = this.getPatchContent(removeAccessCondition);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchReplaceBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
    }

    @Test
    public void uploadTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        MockMultipartFile pdfFile = new MockMultipartFile("file", "/local/path/simple-article.pdf", "application/pdf", pdf);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).file(pdfFile)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"simple-article.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/simple-article.pdf")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"simple-article.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/simple-article.pdf")));
    }

    @Test
    public void uploadUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        MockMultipartFile pdfFile = new MockMultipartFile("file", "/local/path/simple-article.pdf", "application/pdf", pdf);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).file(pdfFile)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files", (Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void uploadForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(eperson1);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("WorkspaceItem").withIssueDate("2019-10-27").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        MockMultipartFile pdfFile = new MockMultipartFile("file", "/local/path/simple-article.pdf", "application/pdf", pdf);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).file(pdfFile)).andExpect(MockMvcResultMatchers.status().isForbidden());
        String authToken2 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files", (Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void createWorkspaceWithFiles_UploadRequired() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        MockMultipartFile pdfFile = new MockMultipartFile("file", "/local/path/simple-article.pdf", "application/pdf", pdf);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).file(pdfFile)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"simple-article.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/simple-article.pdf")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void createWorkspaceWithoutFiles_UploadRequired() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").build();
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.filerequired')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/upload")))))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createWorkspaceItemFromExternalSources() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        Integer workspaceItemId = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            workspaceItemId = (Integer)map.get("id");
            String itemUuidString = String.valueOf(((Map)((Map)map.get("_embedded")).get("item")).get("uuid"));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItemId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)workspaceItemId)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"workspaceitem")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.item", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.contributor.author", "Donald, Smith")})))))));
        }
        catch (Throwable throwable) {
            WorkspaceItemBuilder.deleteWorkspaceItem(workspaceItemId);
            throw throwable;
        }
        WorkspaceItemBuilder.deleteWorkspaceItem((Integer)workspaceItemId);
    }

    @Test
    public void createWorkspaceItemFromExternalSourcesNoOwningCollectionUuidBadRequest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createWorkspaceItemFromExternalSourcesRandomOwningCollectionUuidBadRequest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + UUID.randomUUID()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createWorkspaceItemFromExternalSourcesWrongUriList() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        ObjectMapper mapper = new ObjectMapper();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/mock/mock/mock/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createWorkspaceItemFromExternalSourcesWrongSourceBadRequest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mockWrongSource/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createWorkspaceItemFromExternalSourcesWrongIdResourceNotFound() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/azeazezaezeaz")).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void createWorkspaceItemFromExternalSourcesForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createWorkspaceItemFromExternalSourcesUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/submission/workspaceitems?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createWorkspaceItemFromExternalSourcesNonAdminWithPermission() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        Integer workspaceItemId = null;
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("owningCollection", new String[]{col1.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            workspaceItemId = (Integer)idRef.get();
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItemId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)workspaceItemId)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"workspaceitem")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.item", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.contributor.author", "Donald, Smith")}))})), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.collection", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)col1.getID().toString()))})))));
        }
        finally {
            WorkspaceItemBuilder.deleteWorkspaceItem((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void findByItemUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(witem.getItem().getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workspace Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findByItemUuidMissingParameterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByItemUuidDoesntExistTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(item.getID())})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findByItemUuidForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(witem.getItem().getID())})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByItemUuidUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(witem.getItem().getID())})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchAddMetadataOnSectionNotExistentTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2019-04-25").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addTitle = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        values.add(value);
        addTitle.add((Operation)new AddOperation("/sections/not-existing-section/dc.title", values));
        String patchBody = this.getPatchContent(addTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void patchAddMetadataWrongAttributeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2019-04-25").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addTitle = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        values.add(value);
        addTitle.add((Operation)new AddOperation("/sections/traditionalpageone/dc.not.existing", values));
        String patchBody = this.getPatchContent(addTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchAddTitleOnSectionThatNotContainAttributeTitleTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2019-11-21").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addTitle = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        values.add(value);
        addTitle.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.title", values));
        String patchBody = this.getPatchContent(addTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void lookupPubmedMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1, (String)"123456789/extraction-test").withName("Collection 1").build();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).build();
        WorkspaceItem witem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("This is a test title").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> addId = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "18926410");
        values.add(value);
        addId.add((Operation)new AddOperation("/sections/traditionalpageone/dc.identifier.other", values));
        String patchBody = this.getPatchContent(addId);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"Transfer of peanut allergy from the donor to a lung transplant recipient."))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"Transfer of peanut allergy from the donor to a lung transplant recipient."))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"This is a test title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())));
        ArrayList<Operation> removeTitle = new ArrayList<Operation>();
        removeTitle.add((Operation)new RemoveOperation("/sections/traditionalpageone/dc.title/0"));
        String rmPatchBody = this.getPatchContent(removeTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0]).content(rmPatchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())));
        ArrayList<Operation> addId2 = new ArrayList<Operation>();
        addId2.add((Operation)new AddOperation("/sections/traditionalpageone/dc.identifier.other/-", value));
        patchBody = this.getPatchContent(addId2);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][1].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][0].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.identifier.other'][1].value", (Matcher)Matchers.is((Object)"18926410"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract'][0].value", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void uploadBibtexFileOnExistingSubmissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1, (String)"123456789/extraction-test").withName("Collection 1").build();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).build();
        WorkspaceItem witem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("This is a test title").build();
        this.context.restoreAuthSystemState();
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "/local/path/bibtex-test.bib", "application/x-bibtex", bibtex);
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"My Article"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Nobody Jr"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)"2006"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"bibtex-test.bib")));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/submission/workspaceitems/" + witem2.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)"This is a test title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.contributor.author'][0].value", (Matcher)Matchers.is((Object)"Nobody Jr"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)"2006"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.source'][0].value", (Matcher)Matchers.is((Object)"/local/path/bibtex-test.bib"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].metadata['dc.title'][0].value", (Matcher)Matchers.is((Object)"bibtex-test.bib")));
        }
        finally {
            bibtex.close();
        }
    }

    @Test
    public void patchAcceptLicenseWrontPathTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Example Title").withIssueDate("2019-11-21").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> replaceGrant = new ArrayList<Operation>();
        replaceGrant.add((Operation)new ReplaceOperation("/sections/license/not-existing", (Object)true));
        String patchBody = this.getPatchContent(replaceGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchAcceptLicenseTryToChangeLicenseUrlTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Example Title").withIssueDate("2019-11-21").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> replaceGrant = new ArrayList<Operation>();
        replaceGrant.add((Operation)new ReplaceOperation("/sections/license/granted", (Object)true));
        String patchBody = this.getPatchContent(replaceGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        ArrayList<Operation> replaceLicenseUrl = new ArrayList<Operation>();
        replaceLicenseUrl.add((Operation)new ReplaceOperation("/sections/license/url", (Object)"not.existing"));
        patchBody = this.getPatchContent(replaceLicenseUrl);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchAcceptLicenseTryToChangeDateAccepteLicenseTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Example Title").withIssueDate("2019-11-21").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> replaceGrant = new ArrayList<Operation>();
        replaceGrant.add((Operation)new ReplaceOperation("/sections/license/granted", (Object)true));
        String patchBody = this.getPatchContent(replaceGrant);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        ArrayList<Operation> replaceLicenseUrl = new ArrayList<Operation>();
        replaceLicenseUrl.add((Operation)new ReplaceOperation("/sections/license/acceptanceDate", (Object)"2020-02-14"));
        patchBody = this.getPatchContent(replaceLicenseUrl);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchUploadMetadatoNotExistTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2019-10-25").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addOpts = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "some text");
        addOpts.add((Operation)new AddOperation("/sections/upload/files/0/metadata/dc.not.existing", value));
        String patchBody = this.getPatchContent(addOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchUploadNotConfiguredMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addOpts = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "2020-01-25");
        addOpts.add((Operation)new AddOperation("/sections/upload/files/0/metadata/dc.date.issued", value));
        String patchBody = this.getPatchContent(addOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.bitstream-metadata['dc.date.issued']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone['dc.date.issued']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void patchUploadMissingFieldTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addOpts = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "test text");
        addOpts.add((Operation)new AddOperation("/sections/upload/files/0/metadata", value));
        String patchBody = this.getPatchContent(addOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchUploadNotExistingPropertyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addOpts = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "test text");
        addOpts.add((Operation)new AddOperation("/sections/upload/files/0/not-existing-property/dc.title", value));
        String patchBody = this.getPatchContent(addOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchUploadWithWrongPathTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2017-10-17").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addOpts = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "test text");
        addOpts.add((Operation)new AddOperation("/sections/upload/files/0", value));
        String patchBody = this.getPatchContent(addOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        addOpts.add((Operation)new AddOperation("/sections/upload/files", value));
        patchBody = this.getPatchContent(addOpts);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchDeleteSectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2020-01-21").withSubject("Subject 1").withSubject("Subject 2").withAbstract("Test description abstract").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract']", (Object[])new Object[0]).isNotEmpty());
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add((Operation)new RemoveOperation("/sections/traditionalpagetwo"));
        String patchBody = this.getPatchContent(operations);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.description.abstract']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void patchDeleteMetadataThatNotExistTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2020-04-21").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add((Operation)new RemoveOperation("/sections/traditionalpageone/dc.not.existing/0"));
        String patchBody = this.getPatchContent(operations);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchDeleteMetadataWrongSectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test title").withIssueDate("2019-04-25").withSubject("ExtraEntry").build();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.title/0"));
        String patchBody = this.getPatchContent(operations);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test title", "2019-04-25", "ExtraEntry"))));
    }

    @Test
    public void findOneFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection._embedded.adminGroup", (Matcher)Matchers.nullValue()));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection._embedded.adminGroup", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void uploadBitstreamWithoutAccessConditions() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).build();
        this.context.restoreAuthSystemState();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        MockMultipartFile pdfFile = new MockMultipartFile("file", "/local/path/simple-article.pdf", "application/pdf", pdf);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).file(pdfFile)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
    }

    @Test
    public void patchBitstreamWithAccessConditionOpenAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withFulltext("upload.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("name", "openaccess");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", value));
        String patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"openaccess"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"openaccess"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchBitstreamWithAccessConditionLeaseAndValidEndDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withFulltext("upload.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = new Date();
        String endDateStr = dateFmt.format(endDate);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "lease");
        accessCondition.put("endDate", endDateStr);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"lease"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.is((Object)endDateStr)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"lease"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.is((Object)endDateStr)));
    }

    @Test
    public void patchBitstreamWithAccessConditionLeaseAndInvalidEndDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withFulltext("upload.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = DateUtils.addDays((Date)DateUtils.addMonths((Date)new Date(), (int)6), (int)1);
        String endDateStr = dateFmt.format(endDate);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "lease");
        accessCondition.put("endDate", endDateStr);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
    }

    @Test
    public void patchBitstreamWithAccessConditionEmbargoAndValidStartDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withFulltext("upload.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = new Date();
        String startDateStr = dateFmt.format(startDate);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "embargo");
        accessCondition.put("startDate", startDateStr);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"embargo"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.is((Object)startDateStr))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"embargo"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.is((Object)startDateStr))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchBitstreamWithAccessConditionEmbargoAndInvalidStartDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withFulltext("upload.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = DateUtils.addDays((Date)DateUtils.addMonths((Date)new Date(), (int)36), (int)1);
        String startDateStr = dateFmt.format(startDate);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "embargo");
        accessCondition.put("startDate", startDateStr);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
    }

    @Test
    public void patchBitstreamWithAccessConditionOpenAccessAndStartDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withFulltext("upload.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = new Date();
        String startDateStr = dateFmt.format(startDate);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "openaccess");
        accessCondition.put("startDate", startDateStr);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
    }

    @Test
    public void patchBitstreamWithAccessConditionLeaseMissingDate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withFulltext("upload.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "lease");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions", (Matcher)Matchers.empty()));
    }

    public void deleteWorkspaceItemWithMinRelationshipsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withEntityType("Person").build();
        Item author1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").build();
        Item author2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withEntityType("Publication").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Person").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)person, (String)"isAuthorOfPublication", (String)"isPublicationOfAuthor", (Integer)2, null, (Integer)0, null).withCopyToLeft(false).withCopyToRight(true).build();
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)workspaceItem.getItem(), (Item)author1, (RelationshipType)isAuthorOfPublication).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)workspaceItem.getItem(), (Item)author2, (RelationshipType)isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(400));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + relationship2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + relationship2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void patchUploadAddMultiAccessConditionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Test WorkspaceItem").withIssueDate("2019-10-01").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> addAccessCondition = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("name", "openaccess");
        HashMap<String, String> value2 = new HashMap<String, String>();
        value2.put("name", "administrator");
        values.add(value);
        values.add(value2);
        addAccessCondition.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions", values));
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(this.getPatchContent(addAccessCondition)).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"openaccess"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[1].name", (Matcher)Matchers.is((Object)"administrator")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"openaccess"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[1].name", (Matcher)Matchers.is((Object)"administrator")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void invalidCollectionConfigurationPreventItemCreationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).withTemplateItem().withEntityType("Person").build();
        Item templateItem = col.getTemplateItem();
        this.itemService.addMetadata(this.context, (DSpaceObject)templateItem, "dspace", "entity", "type", null, "Publication");
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        MockMultipartFile pdfFile = new MockMultipartFile("file", "/local/path/myfile.pdf", "application/pdf", pdf);
        this.context.restoreAuthSystemState();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/submission/workspaceitems", (Object[])new Object[0]).file(pdfFile)).andExpect(MockMvcResultMatchers.status().is(500));
        }
        finally {
            pdf.close();
        }
    }

    @Test
    public void patchUploadAddAdminRPInstallAndVerifyOnlyAdminCanView() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test Item patchUploadAddAdminRPInstallAndVerifyOnlyAdminCanView").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "administrator");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        Group anonGroup = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(anonGroup, null, (DSpaceObject)bitstream, null, 0, null)}))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void patchUploadAddOpenAccessRPInstallAndVerifyAnonCanView() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test Item patchUploadAddOpenAccessRPInstallAndVerifyOnlyAdminCanView").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "openaccess");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(this.anonymousGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "openaccess")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(this.anonymousGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "openaccess")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void patchUploadAddAdminThenOpenAccessRPInstallAndVerifyAnonCanView() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test Item patchUploadAddOpenAccessRPInstallAndVerifyOnlyAdminCanView").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "administrator");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")})));
        HashMap<String, String> accessCondition2 = new HashMap<String, String>();
        accessCondition2.put("name", "openaccess");
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        ops2.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition2));
        String patchBody2 = this.getPatchContent(ops2);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody2).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(this.anonymousGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "openaccess")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void patchUploadAddAdminRPInstallAndVerifyOnlyAdminCanViewInAppendModeTest() throws Exception {
        this.configurationService.setProperty("core.authorization.installitem.inheritance-read.append-mode", (Object)true);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test wsItem").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "administrator");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        Group anonGroup = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(anonGroup, null, (DSpaceObject)bitstream, null, 0, null)}))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void patchUploadAddOpenAccessRPInstallAndVerifyAnonCanViewInAppendModeTest() throws Exception {
        this.configurationService.setProperty("core.authorization.installitem.inheritance-read.append-mode", (Object)true);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test wsItem").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "openaccess");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(this.anonymousGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "openaccess")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(this.anonymousGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "openaccess")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void patchUploadAddAdminThenOpenAccessRPInstallAndVerifyAnonCanViewInAppendModeTest() throws Exception {
        this.configurationService.setProperty("core.authorization.installitem.inheritance-read.append-mode", (Object)true);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test wsItem").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "administrator");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")})));
        HashMap<String, String> accessCondition2 = new HashMap<String, String>();
        accessCondition2.put("name", "openaccess");
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        ops2.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition2));
        String patchBody2 = this.getPatchContent(ops2);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody2).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(this.anonymousGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "openaccess")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void patchUploadAddAdminmistratorRPAndVerifyCustomGroupCanViewInAppendModeTest() throws Exception {
        this.configurationService.setProperty("core.authorization.installitem.inheritance-read.append-mode", (Object)true);
        this.context.turnOffAuthorisationSystem();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withEmail("testMyUesr@userstest.net").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        Group customGroup = this.cs.createDefaultReadGroup(this.context, collection, "BITSTREAM", 9);
        this.groupService.addMember(this.context, customGroup, user);
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test wsItem").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String userToken = this.getAuthToken(user.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "administrator");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchUploadAddAdminmistratorRPAndVerifyCustomGroupCannotViewTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withEmail("testMyUesr@userstest.net").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Com").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Col").build();
        Group customGroup = this.cs.createDefaultReadGroup(this.context, collection, "BITSTREAM", 9);
        this.groupService.addMember(this.context, customGroup, user);
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle("Test wsItem").withIssueDate("2019-03-06").withFulltext("upload2.pdf", "/local/path/simple-article.pdf", pdf).build();
        this.context.restoreAuthSystemState();
        String userToken = this.getAuthToken(user.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        HashMap<String, String> accessCondition = new HashMap<String, String>();
        accessCondition.put("name", "administrator");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions/-", accessCondition));
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + wItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        Bitstream bitstream = (Bitstream)((Bundle)wItem.getItem().getBundles().get(0)).getBitstreams().get(0);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{bitstream.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(adminGroup, null, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM, 0, "administrator")})));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wItem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

