/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class CollectionMatcher {
    private CollectionMatcher() {
    }

    public static Matcher<? super Object> matchCollectionEntry(String name, UUID uuid, String handle) {
        return CollectionMatcher.matchCollectionEntry(name, uuid, handle, null);
    }

    public static Matcher<? super Object> matchCollectionEntry(String name, UUID uuid, String handle, Bitstream logo) {
        return Matchers.allOf(CollectionMatcher.matchProperties(name, uuid, handle), CollectionMatcher.matchLinks(uuid));
    }

    public static Matcher<? super Object> matchCollectionEntryFullProjection(String name, UUID uuid, String handle) {
        return CollectionMatcher.matchCollectionEntryFullProjection(name, uuid, handle, null);
    }

    public static Matcher<? super Object> matchCollectionEntryFullProjection(String name, UUID uuid, String handle, Bitstream logo) {
        return Matchers.allOf(CollectionMatcher.matchProperties(name, uuid, handle), CollectionMatcher.matchLinks(uuid), CollectionMatcher.matchLogo(logo), CollectionMatcher.matchFullEmbeds());
    }

    public static Matcher<? super Object> matchCollectionEntrySpecificEmbedProjection(String name, UUID uuid, String handle) {
        return CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(name, uuid, handle, null);
    }

    public static Matcher<? super Object> matchCollectionEntrySpecificEmbedProjection(String name, UUID uuid, String handle, Bitstream logo) {
        return Matchers.allOf(CollectionMatcher.matchProperties(name, uuid, handle), CollectionMatcher.matchLinks(uuid), CollectionMatcher.matchLogo(logo), CollectionMatcher.matchSpecificEmbeds());
    }

    public static Matcher<? super Object> matchProperties(String name, UUID uuid, String handle) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)handle)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", name)})));
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("license", "logo", "parentCommunity", "mappedItems[]", "adminGroup", "submittersGroup", "itemReadGroup", "bitstreamReadGroup");
    }

    public static Matcher<? super Object> matchLinks(UUID uuid) {
        return HalMatcher.matchLinks("http://localhost/api/core/collections/" + uuid, "harvester", "itemtemplate", "license", "logo", "mappedItems", "parentCommunity", "self", "adminGroup", "submittersGroup", "itemReadGroup", "bitstreamReadGroup");
    }

    private static Matcher<? super Object> matchLogo(Bitstream logo) {
        return logo == null ? Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty()))}) : Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$._embedded.logo", BitstreamMatcher.matchBitstreamEntry(logo.getID(), logo.getSizeBytes()))});
    }

    public static String getEmbedsParameter() {
        return "license,logo,parentCommunity,mappedItems";
    }

    public static Matcher<? super Object> matchCollection(Collection collection) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)collection.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)collection.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)collection.getHandle())));
    }

    public static Matcher<? super Object> matchSpecificEmbeds() {
        return HalMatcher.matchEmbeds(CollectionMatcher.getEmbedsParameter().split(","));
    }
}

