/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canCreateCollections", description="It can be used to verify if a user has access to create a new collection within a specific community")
public class CreateCollectionFeature
implements AuthorizationFeature {
    public static final String NAME = "canCreateCollections";
    @Autowired
    AuthorizeService authService;
    @Autowired
    Utils utils;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object != null && object instanceof CommunityRest) {
            Community community = (Community)this.utils.getDSpaceAPIObjectFromRest(context, object);
            return this.authService.authorizeActionBoolean(context, (DSpaceObject)community, 3);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.community"};
    }
}

