/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.projection;

import java.util.List;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.AbstractProjection;
import org.dspace.app.rest.projection.Projection;
import org.springframework.hateoas.Link;

public class CompositeProjection
extends AbstractProjection {
    public static final String NAME = "composite";
    private final List<Projection> projections;

    public CompositeProjection(List<Projection> projections) {
        this.projections = projections;
    }

    public String getName() {
        return NAME;
    }

    public <T> T transformModel(T modelObject) {
        for (Projection projection : this.projections) {
            modelObject = projection.transformModel(modelObject);
        }
        return modelObject;
    }

    public <T extends RestModel> T transformRest(T restObject) {
        for (Projection projection : this.projections) {
            restObject = projection.transformRest(restObject);
        }
        return restObject;
    }

    public <T extends HALResource> T transformResource(T halResource) {
        for (Projection projection : this.projections) {
            halResource = projection.transformResource(halResource);
        }
        return halResource;
    }

    public boolean allowEmbedding(HALResource<? extends RestAddressableModel> halResource, LinkRest linkRest, Link ... oldLinks) {
        for (Projection projection : this.projections) {
            if (!projection.allowEmbedding(halResource, linkRest, oldLinks)) continue;
            return true;
        }
        return false;
    }

    public boolean allowLinking(HALResource halResource, LinkRest linkRest) {
        for (Projection projection : this.projections) {
            if (projection.allowLinking(halResource, linkRest)) continue;
            return false;
        }
        return true;
    }
}

