/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.util.List;
import org.dspace.app.rest.security.RestPermissionEvaluatorPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DSpacePermissionEvaluator
implements PermissionEvaluator {
    @Autowired
    private List<RestPermissionEvaluatorPlugin> permissionEvaluatorPluginList;

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        for (RestPermissionEvaluatorPlugin permissionEvaluatorPlugin : this.permissionEvaluatorPluginList) {
            if (!permissionEvaluatorPlugin.hasPermission(authentication, targetDomainObject, permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        for (RestPermissionEvaluatorPlugin permissionEvaluatorPlugin : this.permissionEvaluatorPluginList) {
            if (!permissionEvaluatorPlugin.hasPermission(authentication, targetId, targetType, permission)) continue;
            return true;
        }
        return false;
    }
}

