/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import javax.servlet.Filter;
import org.dspace.app.rest.exception.DSpaceAccessDeniedHandler;
import org.dspace.app.rest.security.AnonymousAdditionalAuthorizationFilter;
import org.dspace.app.rest.security.CustomLogoutHandler;
import org.dspace.app.rest.security.DSpace401AuthenticationEntryPoint;
import org.dspace.app.rest.security.DSpaceCsrfAuthenticationStrategy;
import org.dspace.app.rest.security.DSpaceCsrfTokenRepository;
import org.dspace.app.rest.security.EPersonRestAuthenticationProvider;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.security.ShibbolethAuthenticationFilter;
import org.dspace.app.rest.security.StatelessAuthenticationFilter;
import org.dspace.app.rest.security.StatelessLoginFilter;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
@Configuration
@EnableConfigurationProperties(value={SecurityProperties.class})
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    public static final String ADMIN_GRANT = "ADMIN";
    public static final String AUTHENTICATED_GRANT = "AUTHENTICATED";
    public static final String ANONYMOUS_GRANT = "ANONYMOUS";
    @Autowired
    private EPersonRestAuthenticationProvider ePersonRestAuthenticationProvider;
    @Autowired
    private RestAuthenticationService restAuthenticationService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private CustomLogoutHandler customLogoutHandler;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private DSpaceAccessDeniedHandler accessDeniedHandler;

    public void configure(WebSecurity webSecurity) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)webSecurity.ignoring().antMatchers(HttpMethod.GET, new String[]{"/api/authn/login"})).antMatchers(HttpMethod.PUT, new String[]{"/api/authn/login"})).antMatchers(HttpMethod.PATCH, new String[]{"/api/authn/login"})).antMatchers(HttpMethod.DELETE, new String[]{"/api/authn/login"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(new String[]{"/api/**", "/iiif/**"})).and().authorizeRequests().antMatchers(HttpMethod.POST, new String[]{"/api/authn/login"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/authn/status"})).permitAll().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).anonymous().authorities(new String[]{ANONYMOUS_GRANT}).and()).servletApi().and()).cors().and()).csrf().csrfTokenRepository(this.getCsrfTokenRepository()).sessionAuthenticationStrategy(this.sessionAuthenticationStrategy()).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new DSpace401AuthenticationEntryPoint(this.restAuthenticationService)).accessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler).and()).logout().addLogoutHandler((LogoutHandler)this.customLogoutHandler).logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/api/authn/logout", HttpMethod.POST.name())).logoutSuccessHandler((LogoutSuccessHandler)new HttpStatusReturningLogoutSuccessHandler(HttpStatus.NO_CONTENT)).permitAll().and()).addFilterBefore((Filter)new AnonymousAdditionalAuthorizationFilter(this.authenticationManager(), this.authenticationService), StatelessAuthenticationFilter.class).addFilterBefore((Filter)new StatelessLoginFilter("/api/authn/login", this.authenticationManager(), this.restAuthenticationService), LogoutFilter.class).addFilterBefore((Filter)new ShibbolethAuthenticationFilter("/api/authn/shibboleth", this.authenticationManager(), this.restAuthenticationService), LogoutFilter.class).addFilterBefore((Filter)new StatelessAuthenticationFilter(this.authenticationManager(), this.restAuthenticationService, this.ePersonRestAuthenticationProvider, this.requestService), StatelessLoginFilter.class);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.ePersonRestAuthenticationProvider);
    }

    public CsrfTokenRepository getCsrfTokenRepository() {
        return new DSpaceCsrfTokenRepository();
    }

    private SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new DSpaceCsrfAuthenticationStrategy(this.getCsrfTokenRepository());
    }
}

