/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.BitstreamFormatMatcher;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.BundleMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BitstreamRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    @Autowired
    private BitstreamFormatService bitstreamFormatService;
    @Autowired
    private GroupService groupService;

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withDescription("description123").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Ignore
    @Test
    public void findAllWithDeletedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        bitstreamContent = "This is a deleted bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.bitstreamService.delete(this.context, (DSpaceObject)bitstream1);
        this.context.commit();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams", (Matcher)Matchers.contains(BitstreamMatcher.matchBitstreamEntry(bitstream))));
    }

    @Test
    public void findOneBitstreamTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withDescription("Description1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchBitstreamEntry(bitstream))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not(BitstreamMatcher.matchBitstreamEntry(bitstream1))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
    }

    @Test
    public void findOneBitstreamTest_EmbargoedBitstream_Anon() throws Exception {
        Bitstream bitstream;
        Item publicItem1;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod("3 months").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchLinks(bitstream.getID())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "?embed=bundles/bitstreams"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams._embedded.bitstreams[0]", BitstreamMatcher.matchProperties(bitstream)));
    }

    @Test
    public void findOneBitstreamFormatTest_EmbargoedBitstream_Anon() throws Exception {
        Bitstream bitstream;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        BitstreamFormat bitstreamFormat = this.bitstreamFormatService.findByMIMEType(this.context, "text/plain");
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType(bitstreamFormat.getMIMEType()).withEmbargoPeriod("3 months").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
    }

    @Test
    public void findOneBitstreamTest_NoReadPolicyOnBitstream_Anon() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)bitstream, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchLinks(bitstream.getID())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "?embed=bundles/bitstreams"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams._embedded.bitstreams[0]", BitstreamMatcher.matchProperties(bitstream)));
    }

    @Test
    public void findOneBitstreamFormatTest_NoReadPolicyOnBitstream_Anon() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        BitstreamFormat bitstreamFormat = this.bitstreamFormatService.findByMIMEType(this.context, "text/plain");
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType(bitstreamFormat.getMIMEType()).build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)bitstream, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
    }

    @Test
    public void findOneBitstreamTest_EmbargoedBitstream_NoREADRightsOnBundle() throws Exception {
        Bitstream bitstream;
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod("3 months").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)bitstream.getBundles().get(0), 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String submitterToken = this.getAuthToken(this.context.getCurrentUser().getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneBitstreamFormatTest_EmbargoedBitstream_NoREADRightsOnBundle() throws Exception {
        Bitstream bitstream;
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        BitstreamFormat bitstreamFormat = this.bitstreamFormatService.findByMIMEType(this.context, "text/plain");
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType(bitstreamFormat.getMIMEType()).withEmbargoPeriod("3 months").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)bitstream.getBundles().get(0), 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String submitterToken = this.getAuthToken(this.context.getCurrentUser().getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
    }

    @Test
    public void findOneBitstreamTest_EmbargoedBitstream_ePersonREADRightsOnBundle() throws Exception {
        Bitstream bitstream;
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod("3 months").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)bitstream.getBundles().get(0), 0);
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withAction(0).withDspaceObject((DSpaceObject)bitstream.getBundles().get(0)).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String submitterToken = this.getAuthToken(this.context.getCurrentUser().getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneBitstreamFormatTest_EmbargoedBitstream_ePersonREADRightsOnBundle() throws Exception {
        Bitstream bitstream;
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        BitstreamFormat bitstreamFormat = this.bitstreamFormatService.findByMIMEType(this.context, "text/plain");
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType(bitstreamFormat.getMIMEType()).withEmbargoPeriod("3 months").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)bitstream.getBundles().get(0), 0);
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withAction(0).withDspaceObject((DSpaceObject)bitstream.getBundles().get(0)).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String submitterToken = this.getAuthToken(this.context.getCurrentUser().getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
    }

    @Test
    public void findOneBitstreamTest_EmbargoedBitstream_NoREADRightsOnItem() throws Exception {
        Bitstream bitstream;
        Item publicItem1;
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod("3 months").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)publicItem1, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String submitterToken = this.getAuthToken(this.context.getCurrentUser().getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneBitstreamTest_EmbargoedBitstream_ePersonREADRightsOnItem() throws Exception {
        Bitstream bitstream;
        Item publicItem1;
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod("3 months").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)publicItem1, 0);
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withAction(0).withDspaceObject((DSpaceObject)publicItem1).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String submitterToken = this.getAuthToken(this.context.getCurrentUser().getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneBitstreamRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withDescription("Description1234").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamFormatMatcher.matchBitstreamFormatMimeType("text/plain")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("ThisIsSomeDummyText"));
    }

    @Test
    public void findOneLogoBitstreamTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withLogo("logo_community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withLogo("logo_collection").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.parentCommunity.getLogo().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + col.getLogo().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneLogoBitstreamRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withLogo("logo_community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withLogo("logo_collection").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.parentCommunity.getLogo().getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("logo_community"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + col.getLogo().getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("logo_collection"));
    }

    @Test
    public void findOneWrongUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteLogo() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withLogo("logo_community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withLogo("logo_collection").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + this.parentCommunity.getLogo().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + col.getLogo().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
    }

    @Test
    public void deleteMissing() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/core/bitstreams/1c11f3f1-ba1f-4f36-908a-3f1ea9a557eb", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/core/bitstreams/1c11f3f1-ba1f-4f36-908a-3f1ea9a557eb", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteDeleted() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchBitstreamMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchBitstreamMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withLogo("logo_community").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/core/bitstreams/" + this.parentCommunity.getLogo().getID(), expectedStatus);
    }

    @Test
    public void testHiddenMetadataForAnonymousUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withProvenance("Provenance Data").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchBitstreamEntry(bitstream))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Bitstream"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadataDoesNotExist("dc.description.provenance")));
    }

    @Test
    public void testHiddenMetadataForAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withProvenance("Provenance Data").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchBitstreamEntry(bitstream))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Bitstream"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.description.provenance", "Provenance Data")));
    }

    @Test
    public void testHiddenMetadataForUserWithWriteRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withProvenance("Provenance Data").withMimeType("text/plain").build();
        }
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withAction(1).withDspaceObject((DSpaceObject)col1).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchBitstreamEntry(bitstream))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Bitstream"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadataDoesNotExist("dc.description.provenance")));
    }

    @Test
    public void getEmbeddedBundleForBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        Bundle bundle = (Bundle)bitstream.getBundles().get(0);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "?embed=bundle"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundle", BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())));
    }

    @Test
    public void linksToFirstBundleWhenMultipleBundles() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
        }
        Bundle secondBundle = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("second bundle").withBitstream(bitstream).build();
        Bundle bundle = (Bundle)bitstream.getBundles().get(0);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())));
    }

    @Test
    public void linksToEmptyWhenNoBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withLogo("logo_community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withLogo("logo_collection").build();
        Bitstream bitstream = this.parentCommunity.getLogo();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void thumbnailEndpointTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test item -- thumbnail").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Bundle originalBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("ORIGINAL").build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("THUMBNAIL").build();
        InputStream is = IOUtils.toInputStream((String)"dummy", (String)"utf-8");
        Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test.pdf").withMimeType("application/pdf").build();
        Bitstream thumbnail = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test.pdf.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)thumbnail.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream")));
    }

    @Test
    public void thumbnailEndpointMultipleThumbnailsWithPrimaryBitstreamTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test item -- thumbnail").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Bundle originalBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("ORIGINAL").build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("THUMBNAIL").build();
        InputStream is = IOUtils.toInputStream((String)"dummy", (String)"utf-8");
        Bitstream bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test1.pdf").withMimeType("application/pdf").build();
        Bitstream bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test2.pdf").withMimeType("application/pdf").build();
        Bitstream primaryBitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test3.pdf").withMimeType("application/pdf").build();
        Bitstream thumbnail1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test1.pdf.jpg").withMimeType("image/jpeg").build();
        Bitstream thumbnail2 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test2.pdf.jpg").withMimeType("image/jpeg").build();
        Bitstream primaryThumbnail = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test3.pdf.jpg").withMimeType("image/jpeg").build();
        originalBundle.setPrimaryBitstreamID(primaryBitstream);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + primaryBitstream.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)primaryThumbnail.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream1.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)thumbnail1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream2.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)thumbnail2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream")));
    }

    @Test
    public void thumbnailEndpointItemWithoutThumbnailsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test item -- thumbnail").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Bundle originalBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("ORIGINAL").build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("THUMBNAIL").build();
        InputStream is = IOUtils.toInputStream((String)"dummy", (String)"utf-8");
        Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test.pdf").withMimeType("application/pdf").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.context.turnOffAuthorisationSystem();
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("random.pdf.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findByHandleAndFileNameForPublicItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream2").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("filename", new String[]{"Bitstream1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("filename", new String[]{"Bitstream2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream2)));
    }

    @Test
    public void findByHandleAndFileNameForEmbargoItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item embargoItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withEmbargoPeriod("6 months").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)embargoItem1, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        Group group = this.groupService.findByName(this.context, "Anonymous");
        bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)embargoItem1, (InputStream)is).withName("Bitstream2").withMimeType("text/plain").withReaderGroup(group).build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{embargoItem1.getHandle()}).param("filename", new String[]{"Bitstream1"})).andExpect(MockMvcResultMatchers.status().isNoContent());
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String admintoken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{embargoItem1.getHandle()}).param("filename", new String[]{"Bitstream1"})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(admintoken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{embargoItem1.getHandle()}).param("filename", new String[]{"Bitstream1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{embargoItem1.getHandle()}).param("filename", new String[]{"Bitstream2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream2)));
    }

    @Test
    public void findByHandleAndFileNameForPrivateItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").makeUnDiscoverable().build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)privateItem1, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)privateItem1, (InputStream)is).withName("Bitstream2").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{privateItem1.getHandle()}).param("filename", new String[]{"Bitstream1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{privateItem1.getHandle()}).param("filename", new String[]{"Bitstream2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream2)));
    }

    @Test
    public void findByHandleAndFileNameForPublicItemWithSameFileName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("BitstreamName").withMimeType("text/plain").build();
        }
        bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("BitstreamName").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("sequence", new String[]{String.valueOf(bitstream2.getSequenceID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("filename", new String[]{"BitstreamName"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
    }

    @Test
    public void findByHandleAndFileNameForPublicItemInLicenseBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        Bundle license = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("LICENSE").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)license, (InputStream)is).withName("BitstreamName").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("filename", new String[]{"BitstreamName"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
    }

    @Test
    public void findByHandleAndFileNameForPublicItemWithCorrectSequenceButWrongName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        Bundle license = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("LICENSE").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)license, (InputStream)is).withName("BitstreamName").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())}).param("filename", new String[]{"WrongBitstreamName"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
    }

    @Test
    public void findByHandleAndFileNameForPublicItemWithFaultyHandle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        Bundle license = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("LICENSE").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)license, (InputStream)is).withName("BitstreamName").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())}).param("filename", new String[]{"WrongBitstreamName"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{"123456789/999999999999"}).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())}).param("filename", new String[]{"WrongBitstreamName"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{this.parentCommunity.getHandle()}).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())}).param("filename", new String[]{"WrongBitstreamName"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{col1.getHandle()}).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())}).param("filename", new String[]{"WrongBitstreamName"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByHandleAndFileNameForPublicItemNoFileNameOrSequence() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        Bundle license = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("LICENSE").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)license, (InputStream)is).withName("BitstreamName").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByHandleAndFileNameForPublicItemNoContent() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        Bundle license = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("LICENSE").build();
        String bitstreamContent = "This is an archived bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)license, (InputStream)is).withName("BitstreamName").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("filename", new String[]{"WrongBitstreamName"})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("sequence", new String[]{"999999"})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findByHandleAndFileNameForPublicItemWithEmbargoOnFile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").build();
        String bitstreamContent = "Embargoed bitstream";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod("3 months").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreams/search/byItemHandle", (Object[])new Object[0]).param("handle", new String[]{publicItem1.getHandle()}).param("sequence", new String[]{String.valueOf(bitstream1.getSequenceID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamMatcher.matchProperties(bitstream1)));
    }
}

