/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;

public class UriListParsingIT
extends AbstractControllerIntegrationTest {
    @Autowired
    protected Utils utils;

    @Test
    public void mockRequestTextUriParsingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        String uriListString = "https://localhost:8080/server/api/core/items/" + publicItem1.getID() + "\nhttps://localhost:8080/server/api/core/items/" + publicItem2.getID();
        mockRequest.setContentType("text/uri-list");
        mockRequest.setContent(uriListString.getBytes());
        List dSpaceObjectList = this.utils.constructDSpaceObjectList(ContextUtil.obtainContext((HttpServletRequest)mockRequest), this.utils.getStringListFromRequest((HttpServletRequest)mockRequest));
        Assert.assertThat((String)"DSpaceObject List is of size 2", (Object)dSpaceObjectList.size(), (Matcher)IsEqual.equalTo((Object)2));
        Assert.assertThat((String)"DSpaceObject 1 is an item", (Object)((DSpaceObject)dSpaceObjectList.get(0)).getType(), (Matcher)IsEqual.equalTo((Object)2));
        Assert.assertThat((String)"DSpaceObject 2 is an item", (Object)((DSpaceObject)dSpaceObjectList.get(1)).getType(), (Matcher)IsEqual.equalTo((Object)2));
        Assert.assertTrue((boolean)((DSpaceObject)dSpaceObjectList.get(0)).equals(publicItem1));
        Assert.assertTrue((boolean)((DSpaceObject)dSpaceObjectList.get(1)).equals(publicItem2));
    }
}

