/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.WorkflowItemMatcher;
import org.dspace.app.rest.matcher.WorkflowStepMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.ClaimedTaskBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class WorkflowItemRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private XmlWorkflowFactory xmlWorkflowFactory;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
    }

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem workflowItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").build();
        XmlWorkflowItem workflowItem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 2").withIssueDate("2016-02-13").build();
        XmlWorkflowItem workflowItem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2016-02-13").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem1, "Workflow Item 1", "2017-10-17"), WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem2, "Workflow Item 2", "2016-02-13"), WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem3, "Workflow Item 3", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/workflowitems"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAllWithPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem workflowItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").build();
        XmlWorkflowItem workflowItem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 2").withIssueDate("2016-02-13").build();
        XmlWorkflowItem workflowItem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2016-02-13").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem1, "Workflow Item 1", "2017-10-17"), WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem2, "Workflow Item 2", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem3, "Workflow Item 3", "2016-02-13")))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.contains((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem3, "Workflow Item 3", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem1, "Workflow Item 1", "2017-10-17"), WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workflowItem2, "Workflow Item 2", "2016-02-13")})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.eperson}).build();
        XmlWorkflowItem workflowItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").build();
        XmlWorkflowItem workflowItem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 2").withIssueDate("2016-02-13").build();
        XmlWorkflowItem workflowItem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2016-02-13").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 3").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        XmlWorkflowItem witem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").build();
        XmlWorkflowItem witem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 2").build();
        XmlWorkflowItem witem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col3).withTitle("Workflow Item 3").build();
        ClaimedTask claimed1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Pool 1").build();
        XmlWorkflowItem wClaimed1 = claimed1.getWorkflowItem();
        ClaimedTask claimed2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Pool 2").build();
        XmlWorkflowItem wClaimed2 = claimed2.getWorkflowItem();
        ClaimedTask claimed3 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col3, (EPerson)reviewer3).withTitle("Pool 3").build();
        XmlWorkflowItem wClaimed3 = claimed3.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String rev1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String rev2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String rev3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + claimed1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(rev1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(rev1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(rev1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(rev2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(rev2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(rev3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(rev3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + wClaimed3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID() + "/collection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID() + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(witem.getItem(), "Workflow Item 1", "2017-10-17"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID() + "/submissionDefinition"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"traditional")))));
    }

    @Test
    public void findOneWrongIDTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findBySubmitterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter1@example.com").build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter2@example.com").build();
        this.context.setCurrentUser(submitter1);
        XmlWorkflowItem workspaceItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").build();
        XmlWorkflowItem workspaceItem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 2").withIssueDate("2016-02-13").build();
        this.context.setCurrentUser(submitter2);
        XmlWorkflowItem workspaceItem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2016-02-13").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"20"}).param("uuid", new String[]{submitter1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workflow Item 1", "2017-10-17"), WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workflow Item 2", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workflow Item 3", "2016-02-13"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"}).param("uuid", new String[]{submitter1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.contains((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem2, "Workflow Item 2", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem1, "Workflow Item 1", "2017-10-17"), WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workflow Item 3", "2016-02-13")})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"20"}).param("uuid", new String[]{submitter2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitems", (Matcher)Matchers.contains((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(workspaceItem3, "Workflow Item 3", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void deleteOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").build();
        Item item = witem.getItem();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (Charset)Charset.defaultCharset());){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenSubmitter = this.getAuthToken(submitter.getEmail(), "dspace");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("uuid", new String[]{submitter.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(null, "Workflow Item 1", "2017-10-17")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/submission/workspaceitems"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void depositWorkspaceItemWithoutWorkflowTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{submitter}).build();
        this.context.setCurrentUser(submitter);
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem wsitem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Submission Item").withIssueDate("2017-10-17").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).grantLicense().build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(submitter.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wsitem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createWorkflowItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        AtomicReference idRef = new AtomicReference();
        try {
            this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
            Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
            EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
            this.context.setCurrentUser(submitter);
            WorkspaceItem wsitem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Submission Item").withIssueDate("2017-10-17").build();
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(submitter.getEmail(), "dspace");
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + wsitem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Submission Item", "2017-10-17"))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Submission Item", "2017-10-17"))));
        }
        finally {
            WorkflowItemBuilder.deleteWorkflowItem((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void unvalidCreateWorkflowItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(submitter.getEmail(), "dspace");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + UUID.randomUUID().toString()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("").contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    public void validationErrorsRequiredMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.eperson}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").build();
        XmlWorkflowItem witemMissingFields = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/worfklowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/worfklowitems/" + witemMissingFields.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.required')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.date.issued")))))));
    }

    @Test
    public void patchUpdateMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(2, new EPerson[]{this.eperson}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)this.eperson).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        claimedTask.setStepID("editstep");
        claimedTask.setActionID("editaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    @Ignore(value="This demonstrate the bug logged in DS-4179")
    public void patchUpdateMetadataStep1ForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.eperson}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void patchUpdateMetadataStep3Test() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(3, new EPerson[]{this.eperson}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)this.eperson).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        claimedTask.setStepID("editstep");
        claimedTask.setActionID("editaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void patchDeleteMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.eperson}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)this.eperson).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        claimedTask.setStepID("editstep");
        claimedTask.setActionID("editaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)this.eperson).withTitle("Workflow Item 2").withIssueDate("2017-10-17").withSubject("Subject1").withSubject("Subject2").withSubject("Subject3").withSubject("Subject4").build();
        claimedTask2.setStepID("editstep");
        claimedTask2.setActionID("editaction");
        XmlWorkflowItem witemMultipleSubjects = claimedTask2.getWorkflowItem();
        ClaimedTask claimedTask3 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)this.eperson).withTitle("Workflow Item 3").withIssueDate("2017-10-17").withSubject("Subject1").withSubject("Subject2").withSubject("Subject3").withSubject("Subject4").build();
        claimedTask3.setStepID("editstep");
        claimedTask3.setActionID("editaction");
        XmlWorkflowItem witemWithTitleDateAndSubjects = claimedTask3.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> removeTitle = new ArrayList<Operation>();
        removeTitle.add((Operation)new RemoveOperation("/sections/traditionalpageone/dc.title/0"));
        String patchBody = this.getPatchContent(removeTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.required')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.title"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, null, "2017-10-17", "ExtraEntry"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors[?(@.message=='error.validation.required')]", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$.paths", (Matcher)Matchers.contains((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)Matchers.is((Object)"/sections/traditionalpageone/dc.title"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, null, "2017-10-17", "ExtraEntry"))));
        ArrayList<Operation> removeMidSubject = new ArrayList<Operation>();
        removeMidSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/1"));
        patchBody = this.getPatchContent(removeMidSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject4")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject4")));
        ArrayList<Operation> removeFirstSubject = new ArrayList<Operation>();
        removeFirstSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/0"));
        patchBody = this.getPatchContent(removeFirstSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject4")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject4")));
        ArrayList<Operation> removeLastSubject = new ArrayList<Operation>();
        removeLastSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/1"));
        patchBody = this.getPatchContent(removeLastSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject3")));
        ArrayList<Operation> removeFinalSubject = new ArrayList<Operation>();
        removeFinalSubject.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject/0"));
        patchBody = this.getPatchContent(removeFinalSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witemMultipleSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
        ArrayList<Operation> removeSubjectsAllAtOnce = new ArrayList<Operation>();
        removeSubjectsAllAtOnce.add((Operation)new RemoveOperation("/sections/traditionalpagetwo/dc.subject"));
        patchBody = this.getPatchContent(removeSubjectsAllAtOnce);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witemWithTitleDateAndSubjects.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witemWithTitleDateAndSubjects.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void patchAddMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.eperson}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)this.eperson).withIssueDate("2017-10-17").withSubject("ExtraEntry").build();
        claimedTask.setStepID("editstep");
        claimedTask.setActionID("editaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addTitle = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        values.add(value);
        addTitle.add((Operation)new AddOperation("/sections/traditionalpageone/dc.title", values));
        String patchBody = this.getPatchContent(addTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void patchAddMultipleMetadataValuesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.eperson}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword("dspace").build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)this.eperson).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        claimedTask.setStepID("editstep");
        claimedTask.setActionID("editaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> addSubjects = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value1 = new HashMap<String, String>();
        value1.put("value", "Subject1");
        HashMap<String, String> value2 = new HashMap<String, String>();
        value2.put("value", "Subject2");
        values.add(value1);
        values.add(value2);
        addSubjects.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject", values));
        String patchBody = this.getPatchContent(addSubjects);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject2")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject2")));
        ArrayList<Operation> addFirstSubject = new ArrayList<Operation>();
        HashMap<String, String> firstSubject = new HashMap<String, String>();
        firstSubject.put("value", "First Subject");
        addFirstSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/0", firstSubject));
        patchBody = this.getPatchContent(addFirstSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject2")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Subject2")));
        ArrayList<Operation> addMidSubject = new ArrayList<Operation>();
        HashMap<String, String> midSubject = new HashMap<String, String>();
        midSubject.put("value", "Mid Subject");
        addMidSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/2", midSubject));
        patchBody = this.getPatchContent(addMidSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2")));
        ArrayList<Operation> addLastSubject = new ArrayList<Operation>();
        HashMap<String, String> lastSubject = new HashMap<String, String>();
        lastSubject.put("value", "Last Subject");
        addLastSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/4", lastSubject));
        patchBody = this.getPatchContent(addLastSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject")));
        ArrayList<Operation> addFinalSubject = new ArrayList<Operation>();
        HashMap<String, String> finalSubject = new HashMap<String, String>();
        finalSubject.put("value", "Final Subject");
        addFinalSubject.add((Operation)new AddOperation("/sections/traditionalpagetwo/dc.subject/-", finalSubject));
        patchBody = this.getPatchContent(addFinalSubject);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][5].value", (Matcher)Matchers.is((Object)"Final Subject")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)"First Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][1].value", (Matcher)Matchers.is((Object)"Subject1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][2].value", (Matcher)Matchers.is((Object)"Mid Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][3].value", (Matcher)Matchers.is((Object)"Subject2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][4].value", (Matcher)Matchers.is((Object)"Last Subject"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][5].value", (Matcher)Matchers.is((Object)"Final Subject")));
    }

    @Test
    public void findByItemUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(witem.getItem().getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findByItemUuidMissingParameterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/item", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByItemUuidDoesntExistTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(item.getID())})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findByItemUuidForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(witem.getItem().getID())})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByItemUuidUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/workflowitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(witem.getItem().getID())})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void stepEmbedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 3").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        XmlWorkflowItem witem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2016-02-13").build();
        XmlWorkflowItem witem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 2").withIssueDate("2016-02-13").build();
        XmlWorkflowItem witem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col3).withTitle("Workflow Item 3").withIssueDate("2016-02-13").build();
        Step step = this.xmlWorkflowFactory.getStepByName("reviewstep");
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(witem1, "Workflow Item 1", "2016-02-13"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)));
        step = this.xmlWorkflowFactory.getStepByName("editstep");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem2.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(witem2, "Workflow Item 2", "2016-02-13"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)));
        step = this.xmlWorkflowFactory.getStepByName("finaleditstep");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem3.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(witem3, "Workflow Item 3", "2016-02-13"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)));
    }

    @Test
    public void discoverableNestedLinkTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.claimedtasks.href", (Matcher)Matchers.is((Object)"http://localhost/api/workflow/claimedtasks")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.claimedtasks-search.href", (Matcher)Matchers.is((Object)"http://localhost/api/workflow/claimedtasks/search")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.pooltasks.href", (Matcher)Matchers.is((Object)"http://localhost/api/workflow/pooltasks")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.pooltasks-search.href", (Matcher)Matchers.is((Object)"http://localhost/api/workflow/pooltasks/search")))));
    }

    @Test
    public void findOneFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection._embedded.adminGroup", (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection._embedded.adminGroup", (Matcher)Matchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenWorkspaceitemBecomeWorkflowitemWithAccessConditionsTheBitstremMustBeDownloableTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Bitstream bitstream = null;
        WorkspaceItem witem = null;
        String bitstreamContent = "0123456789";
        AtomicReference idRef = new AtomicReference();
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (Charset)Charset.defaultCharset());){
            this.context.setCurrentUser(submitter);
            witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection1).withTitle("Test WorkspaceItem").withIssueDate("2019-10-01").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)witem.getItem(), (InputStream)is).withName("Test bitstream").withDescription("This is a bitstream to test range requests").withMimeType("text/plain").build();
            this.context.restoreAuthSystemState();
            String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
            String tokenSubmitter = this.getAuthToken(submitter.getEmail(), this.password);
            String tokenReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Accept-Ranges", "bytes")).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + bitstream.getChecksum() + "\"")).andExpect(MockMvcResultMatchers.content().contentType("text/plain")).andExpect(MockMvcResultMatchers.content().bytes(bitstreamContent.getBytes()));
            this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
            ArrayList<Operation> addAccessCondition = new ArrayList<Operation>();
            ArrayList accessConditions = new ArrayList();
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("name", "administrator");
            accessConditions.add(value);
            addAccessCondition.add((Operation)new AddOperation("/sections/upload/files/0/accessConditions", accessConditions));
            String patchBody = this.getPatchContent(addAccessCondition);
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"administrator"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"administrator"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + witem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Test WorkspaceItem", "2019-10-01")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].name", (Matcher)Matchers.is((Object)"administrator"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].startDate", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.upload.files[0].accessConditions[0].endDate", (Matcher)Matchers.nullValue()));
            this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Accept-Ranges", "bytes")).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + bitstream.getChecksum() + "\"")).andExpect(MockMvcResultMatchers.content().contentType("text/plain")).andExpect(MockMvcResultMatchers.content().bytes(bitstreamContent.getBytes()));
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Accept-Ranges", "bytes")).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + bitstream.getChecksum() + "\"")).andExpect(MockMvcResultMatchers.content().contentType("text/plain")).andExpect(MockMvcResultMatchers.content().bytes(bitstreamContent.getBytes()));
            this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            WorkflowItemBuilder.deleteWorkflowItem((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenWorkspaceitemBecomeWorkflowitemWithAccessConditionsTheItemMustBeAccessibleTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        this.context.setCurrentUser(submitter);
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection1).withTitle("Test WorkspaceItem").withIssueDate("2019-10-01").build();
        UUID itemUuid = witem.getItem().getID();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenSubmitter = this.getAuthToken(submitter.getEmail(), this.password);
        String tokenReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemWithTitleAndDateIssued(witem.getItem(), "Test WorkspaceItem", "2019-10-01")));
        this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        ArrayList<Operation> addAccessCondition = new ArrayList<Operation>();
        ArrayList accessConditions = new ArrayList();
        HashMap<String, String> accessCondition2 = new HashMap<String, String>();
        accessCondition2.put("name", "administrator");
        accessConditions.add(accessCondition2);
        addAccessCondition.add((Operation)new AddOperation("/sections/defaultAC/accessConditions", accessConditions));
        String patchBody = this.getPatchContent(addAccessCondition);
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.discoverable", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.accessConditions[0].name", (Matcher)Matchers.is((Object)"administrator"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.accessConditions[1].name", (Object[])new Object[0]).doesNotExist());
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + witem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Test WorkspaceItem", "2019-10-01")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.discoverable", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.accessConditions[0].name", (Matcher)Matchers.is((Object)"administrator"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.accessConditions[1].name", (Object[])new Object[0]).doesNotExist());
            this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemWithTitleAndDateIssued(witem.getItem(), "Test WorkspaceItem", "2019-10-01")));
            this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemWithTitleAndDateIssued(witem.getItem(), "Test WorkspaceItem", "2019-10-01")));
            this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            WorkflowItemBuilder.deleteWorkflowItem((Integer)((Integer)idRef.get()));
        }
    }
}

