/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="alwaystruetestgroup")
public class TrueForUsersInGroupTestFeature
implements AuthorizationFeature {
    public static final String NAME = "alwaystruetestgroup";
    public static final String GROUP_NAME = "Test Feature Group";
    @Autowired
    private GroupService groupService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (context.getCurrentUser() == null) {
            return false;
        }
        Group testGroup = this.groupService.findByName(context, GROUP_NAME);
        if (testGroup != null) {
            return this.groupService.isMember(context, testGroup);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.site", "core.community", "core.item"};
    }
}

