/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.LinkedList;
import org.dspace.app.rest.converter.DiscoverFacetConfigurationConverter;
import org.dspace.app.rest.model.FacetConfigurationRest;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DiscoverFacetConfigurationConverterTest {
    FacetConfigurationRest facetConfigurationRest;
    @InjectMocks
    private DiscoverFacetConfigurationConverter discoverFacetConfigurationConverter;
    @Mock
    private DiscoveryConfiguration discoveryConfiguration;
    private String configurationName = "default";
    private String scopeObject = "ba9e1c83-8144-4e9c-9d58-bb97be573b46";

    public void populateDiscoveryConfigurationWithEmptyList() {
        this.discoveryConfiguration.setSidebarFacets(new LinkedList());
    }

    @Test
    public void testReturnType() throws Exception {
        this.populateDiscoveryConfigurationWithEmptyList();
        this.facetConfigurationRest = this.discoverFacetConfigurationConverter.convert(this.configurationName, this.scopeObject, this.discoveryConfiguration);
        Assert.assertTrue((boolean)this.facetConfigurationRest.getSidebarFacets().isEmpty());
        Assert.assertEquals(FacetConfigurationRest.class, this.facetConfigurationRest.getClass());
    }

    @Test
    public void testConvertWithNullParamter() throws Exception {
        this.facetConfigurationRest = this.discoverFacetConfigurationConverter.convert(this.configurationName, this.scopeObject, null);
        Assert.assertNotNull((Object)this.facetConfigurationRest);
        Assert.assertTrue((boolean)this.facetConfigurationRest.getSidebarFacets().isEmpty());
    }

    @Test
    public void testConvertWithConfigurationContainingSidebarFacetsFacetConfigurationRestContainsCorrectSidebarFacet() throws Exception {
        LinkedList<DiscoverySearchFilterFacet> discoverySearchFilterFacets = new LinkedList<DiscoverySearchFilterFacet>();
        DiscoverySearchFilterFacet discoverySearchFilterFacet = new DiscoverySearchFilterFacet();
        discoverySearchFilterFacet.setIndexFieldName("Testing");
        discoverySearchFilterFacet.setType("test");
        discoverySearchFilterFacets.add(discoverySearchFilterFacet);
        Mockito.when((Object)this.discoveryConfiguration.getSidebarFacets()).thenReturn(discoverySearchFilterFacets);
        this.facetConfigurationRest = this.discoverFacetConfigurationConverter.convert(this.configurationName, this.scopeObject, this.discoveryConfiguration);
        Assert.assertNotNull((Object)this.facetConfigurationRest);
        Assert.assertTrue((!this.facetConfigurationRest.getSidebarFacets().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)discoverySearchFilterFacet.getIndexFieldName(), (Object)((SearchFacetEntryRest)this.facetConfigurationRest.getSidebarFacets().get(0)).getName());
        Assert.assertEquals((Object)discoverySearchFilterFacet.getType(), (Object)((SearchFacetEntryRest)this.facetConfigurationRest.getSidebarFacets().get(0)).getFacetType());
    }

    @Test
    public void testConvertWithConfigurationContainingEmptySidebarFacetListFacetConfigurationRestSidebarFacetsIsEmpty() throws Exception {
        Mockito.when((Object)this.discoveryConfiguration.getSidebarFacets()).thenReturn(new LinkedList());
        this.facetConfigurationRest = this.discoverFacetConfigurationConverter.convert(this.configurationName, this.scopeObject, this.discoveryConfiguration);
        Assert.assertNotNull((Object)this.facetConfigurationRest);
        Assert.assertTrue((boolean)this.facetConfigurationRest.getSidebarFacets().isEmpty());
    }

    @Test
    public void testConvertWithConfigurationContainingNullSidebarFacetListFacetConfigurationRestSidebarFacetsIsEmpty() throws Exception {
        Mockito.when((Object)this.discoveryConfiguration.getSidebarFacets()).thenReturn(null);
        this.facetConfigurationRest = this.discoverFacetConfigurationConverter.convert(this.configurationName, this.scopeObject, this.discoveryConfiguration);
        Assert.assertNotNull((Object)this.facetConfigurationRest);
        Assert.assertTrue((boolean)this.facetConfigurationRest.getSidebarFacets().isEmpty());
    }
}

