/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.iiif;

import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class IIIFControllerIT
extends AbstractControllerIntegrationTest {
    public static final String IIIFBundle = "IIIF";
    @Autowired
    ItemService itemService;

    @Test
    public void disabledTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").disableIIIF().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem2.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void notFoundTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + UUID.randomUUID().toString() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void findOneIIIFSearchableEntityTypeWithGlobalConfigIT() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().enableIIIFSearch().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream1 = null;
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream2.png").withMimeType("image/png").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service.profile", (Matcher)Matchers.is((Object)"http://iiif.io/api/search/0/search"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.thumbnail.@id", (Matcher)Matchers.containsString((String)("/iiif/2/" + bitstream1.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].label", (Matcher)Matchers.is((Object)"Title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].value", (Matcher)Matchers.is((Object)"Public item 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[1].label", (Matcher)Matchers.is((Object)"Issue Date"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[1].value", (Matcher)Matchers.is((Object)"2017-10-17"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[2].label", (Matcher)Matchers.is((Object)"Authors"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[2].value[0]", (Matcher)Matchers.is((Object)"Smith, Donald"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[2].value[1]", (Matcher)Matchers.is((Object)"Doe, John"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Page 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].width", (Matcher)Matchers.is((Object)2200))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].images[0].resource.service.@id", (Matcher)Matchers.endsWith((String)bitstream1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[0].label", (Matcher)Matchers.is((Object)"File name"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[0].value", (Matcher)Matchers.is((Object)"Bitstream1.jpg"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[1].label", (Matcher)Matchers.is((Object)"Format"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[1].value", (Matcher)Matchers.is((Object)"JPEG"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[2].label", (Matcher)Matchers.is((Object)"Mime Type"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[2].value", (Matcher)Matchers.is((Object)"image/jpeg"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[3].label", (Matcher)Matchers.is((Object)"File size"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[3].value", (Matcher)Matchers.is((Object)"19 bytes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[4].label", (Matcher)Matchers.is((Object)"Checksum"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].metadata[4].value", (Matcher)Matchers.is((Object)"11e23c5702595ba512c1c2ee8e8d6153 (MD5)"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Page 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].images[0].resource.service.@id", (Matcher)Matchers.endsWith((String)bitstream2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.related.@id", (Matcher)Matchers.containsString((String)("/items/" + publicItem1.getID()))));
    }

    @Test
    public void findOneIIIFSearchableWithMixedConfigIT() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().withIIIFCanvasWidth(2000).withIIIFCanvasHeight(3000).withIIIFCanvasNaming("Global").enableIIIFSearch().build();
        String bitstreamContent = "ThisIsSomeText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").withIIIFLabel("Custom Label").withIIIFCanvasWidth(3163).withIIIFCanvasHeight(4220).build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream2.jpg").withMimeType("image/jpeg").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Custom Label"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].width", (Matcher)Matchers.is((Object)3163))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].height", (Matcher)Matchers.is((Object)4220))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Global 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].width", (Matcher)Matchers.is((Object)2000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].height", (Matcher)Matchers.is((Object)3000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).exists());
    }

    @Test
    public void findOneIIIFSearchableWithCustomBundleAndConfigIT() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().enableIIIFSearch().build();
        String bitstreamContent = "ThisIsSomeText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream1.png").withMimeType("image/png").withIIIFLabel("Custom Label").withIIIFCanvasWidth(3163).withIIIFCanvasHeight(4220).build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Custom Label"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].width", (Matcher)Matchers.is((Object)3163))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].height", (Matcher)Matchers.is((Object)4220))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).exists());
    }

    @Test
    public void findOneIIIFEntityPagedHintIT() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withMetadata("dc", "rights", "uri", "https://license.org").enableIIIF().build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withMetadata("dc", "rights", "uri", "https://license.org").withIIIFViewingHint("paged").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem2, (InputStream)is, (String)IIIFBundle).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        String bitstreamContent2 = "ThisIsSomeDummyText2";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent2, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream2.png").withMimeType("image/png").build();
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem2, (InputStream)is, (String)IIIFBundle).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        String bitstreamContent3 = "ThisIsSomeDummyText3";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent3, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream3.tiff").withMimeType("image/tiff").build();
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem2, (InputStream)is, (String)IIIFBundle).withName("Bitstream3.tiff").withMimeType("image/tiff").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.license", (Matcher)Matchers.is((Object)"https://license.org"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.viewingHint", (Matcher)Matchers.is((Object)"individuals"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).doesNotExist());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem2.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.license", (Matcher)Matchers.is((Object)"https://license.org"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.viewingHint", (Matcher)Matchers.is((Object)"paged"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findOneWithStructures() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withIIIFCanvasHeight(3000).withIIIFCanvasWidth(2000).withIIIFCanvasNaming("Global").enableIIIF().enableIIIFSearch().build();
        String bitstreamContent = "ThisIsSomeText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream1.jpg").withMimeType("image/jpeg").withIIIFToC("Section 1").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream2.png").withMimeType("image/png").withIIIFToC("Section 2").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream3.tiff").withMimeType("image/tiff").withIIIFToC("Section 2").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Global 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].width", (Matcher)Matchers.is((Object)2000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].height", (Matcher)Matchers.is((Object)3000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Global 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[2].label", (Matcher)Matchers.is((Object)"Global 3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].label", (Matcher)Matchers.is((Object)"Table of Contents"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].viewingHint", (Matcher)Matchers.is((Object)"top"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].ranges[0]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].ranges[1]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].label", (Matcher)Matchers.is((Object)"Section 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].label", (Matcher)Matchers.is((Object)"Section 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].canvases[1]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).exists());
    }

    @Test
    public void findOneWithBundleStructures() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withIIIFCanvasHeight(3000).withIIIFCanvasWidth(2000).withIIIFCanvasNaming("Global").enableIIIF().enableIIIFSearch().build();
        String bitstreamContent = "ThisIsSomeText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream2.png").withMimeType("image/png").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)IIIFBundle).withName("Bitstream3.tiff").withMimeType("image/tiff").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Global 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].width", (Matcher)Matchers.is((Object)2000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].height", (Matcher)Matchers.is((Object)3000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Global 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[2].label", (Matcher)Matchers.is((Object)"Global 3"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].label", (Matcher)Matchers.is((Object)"Table of Contents"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].viewingHint", (Matcher)Matchers.is((Object)"top"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].ranges[0]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].ranges[1]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].label", (Matcher)Matchers.is((Object)"ORIGINAL"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].label", (Matcher)Matchers.is((Object)IIIFBundle))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].canvases[1]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).exists());
    }

    @Test
    public void findOneWithHierarchicalStructures() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().enableIIIFSearch().build();
        String bitstreamContent = "ThisIsSomeText";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").withIIIFToC("Section 1").build();
        }
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFToC("Section 1|||a").build();
        }
        Bitstream bitstream3 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream3 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream3.jpg").withMimeType("image/jpeg").withIIIFToC("Section 1|||a").build();
        }
        Bitstream bitstream4 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream4 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream4.jpg").withMimeType("image/jpeg").withIIIFToC("Section 1|||b").build();
        }
        Bitstream bitstream5 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream5 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream5.jpg").withMimeType("image/jpeg").withIIIFToC("Section 1").build();
        }
        Bitstream bitstream6 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream6 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream6.png").withMimeType("image/png").withIIIFToC("Section 2").build();
        }
        Bitstream bitstream7 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream7 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream7.tiff").withMimeType("image/tiff").withIIIFToC("Section 2").build();
        }
        Bitstream bitstream8 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream8 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream8.tiff").withMimeType("image/tiff").withIIIFToC("Section 2|||sub 2-1").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases", (Matcher)Matchers.hasSize((int)8))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[2].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[2].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream3.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[3].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[3].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream4.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[4].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c4")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[4].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream5.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[5].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c5")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[5].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream6.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[6].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c6")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[6].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream7.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[7].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c7")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[7].images[0].resource.@id", (Matcher)Matchers.containsString((String)bitstream8.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].label", (Matcher)Matchers.is((Object)"Table of Contents"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].viewingHint", (Matcher)Matchers.is((Object)"top"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].ranges", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].ranges[0]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].ranges[1]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[0].canvases", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].label", (Matcher)Matchers.is((Object)"Section 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].ranges", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].ranges[0]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].ranges[1]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0-1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].canvases", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[1].canvases[1]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c4")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].label", (Matcher)Matchers.is((Object)"a"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].ranges", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].canvases", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[2].canvases[1]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[3].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-0-1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[3].label", (Matcher)Matchers.is((Object)"b"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[3].ranges", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[3].canvases", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[3].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[4].label", (Matcher)Matchers.is((Object)"Section 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[4].ranges", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[4].ranges[0]", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-1-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[4].canvases", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[4].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c5")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[4].canvases[1]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c6")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[5].@id", (Matcher)Matchers.endsWith((String)("/iiif/" + publicItem1.getID() + "/manifest/range/r0-1-0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[5].label", (Matcher)Matchers.is((Object)"sub 2-1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[5].ranges", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[5].canvases", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures[5].canvases[0]", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c7")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).exists());
    }

    @Test
    public void findOneIIIFNotSearcheableIT() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withMetadata("dc", "rights", "uri", "https://license.org").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.license", (Matcher)Matchers.is((Object)"https://license.org"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Page 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findOneIIIFWithOtherContentIT() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withMetadata("dc", "rights", "uri", "https://license.org").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)"OtherContent").withName("file.xml").withMimeType("application/xml").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.license", (Matcher)Matchers.is((Object)"https://license.org"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.seeAlso.@type", (Matcher)Matchers.is((Object)"sc:AnnotationList"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Page 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findOneUsingOriginalBundleIgnoreFileIT() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream2.mp4").withMimeType("video/mp4").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Bitstream pdf = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            pdf = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream3.pdf").withMimeType("application/pdf").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + publicItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Page 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rendering.@id", (Matcher)Matchers.endsWith((String)(pdf.getID().toString() + "/content")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rendering.label", (Matcher)Matchers.is((Object)"Bitstream3.pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rendering.format", (Matcher)Matchers.is((Object)"application/pdf"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findOneIIIFRestrictedItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Group staffGroup = GroupBuilder.createGroup((Context)this.context).withName("Staff").build();
        Group anotherGroup = GroupBuilder.createGroup((Context)this.context).withName("anotherGroup").build();
        Item restrictedItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Restricted item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().withIIIFCanvasWidth(2000).withIIIFCanvasHeight(3000).withIIIFCanvasNaming("Global").enableIIIFSearch().withReaderGroup(staffGroup).build();
        EPerson staffEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("staff@example.com").withPassword(this.password).withGroupMembership(staffGroup).build();
        String bitstreamContent = "ThisIsSomeText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)restrictedItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").withIIIFLabel("Custom Label").withIIIFCanvasWidth(3163).withIIIFCanvasHeight(4220).withReaderGroup(staffGroup).build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            BitstreamBuilder.createBitstream((Context)this.context, (Item)restrictedItem1, (InputStream)is).withName("Bitstream2.jpg").withMimeType("image/jpeg").withReaderGroup(anotherGroup).build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + restrictedItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + restrictedItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(this.getAuthToken(staffEperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + restrictedItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@context", (Matcher)Matchers.is((Object)"http://iiif.io/api/presentation/2/context.json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].@id", (Matcher)Matchers.containsString((String)("/iiif/" + restrictedItem1.getID() + "/canvas/c0")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].label", (Matcher)Matchers.is((Object)"Custom Label"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].width", (Matcher)Matchers.is((Object)3163))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[0].height", (Matcher)Matchers.is((Object)4220))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].@id", (Matcher)Matchers.containsString((String)("/iiif/" + restrictedItem1.getID() + "/canvas/c1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Global 2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].width", (Matcher)Matchers.is((Object)2000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].height", (Matcher)Matchers.is((Object)3000))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.structures", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.service", (Object[])new Object[0]).exists());
    }

    @Test
    public void findOneCanvas() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("IMG1.jpg").withMimeType("image/jpeg").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/canvas/c0"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@type", (Matcher)Matchers.is((Object)"sc:Canvas"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].label", (Matcher)Matchers.is((Object)"File name"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].value", (Matcher)Matchers.is((Object)"IMG1.jpg"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[1].label", (Matcher)Matchers.is((Object)"Format"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[1].value", (Matcher)Matchers.is((Object)"JPEG"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[2].label", (Matcher)Matchers.is((Object)"Mime Type"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[2].value", (Matcher)Matchers.is((Object)"image/jpeg"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[3].label", (Matcher)Matchers.is((Object)"File size"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[3].value", (Matcher)Matchers.is((Object)"19 bytes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[4].label", (Matcher)Matchers.is((Object)"Checksum"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[4].value", (Matcher)Matchers.is((Object)"11e23c5702595ba512c1c2ee8e8d6153 (MD5)"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.images[0].@type", (Matcher)Matchers.is((Object)"oa:Annotation")));
    }

    @Test
    public void missingCanvas() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("IMG1.jpg").withMimeType("image/jpeg").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/canvas/c2"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void getAnnotationListSeeAlso() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("IMG1.jpg").withMimeType("image/jpeg").build();
        }
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is, (String)"OtherContent").withName("file.xml").withMimeType("application/xml").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest/seeAlso"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.@type", (Matcher)Matchers.is((Object)"sc:AnnotationList"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.resources[0].@type", (Matcher)Matchers.is((Object)"oa:Annotation"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.resources[0].motivation", (Matcher)Matchers.is((Object)"oa:linking"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.resources[0].resource.@id", (Matcher)Matchers.containsString((String)(bitstream2.getID() + "/content"))));
    }

    @Test
    public void findOneWithCacheEvictionAfterBitstreamUpdate() throws Exception {
        String patchRequestBody = "[{\"op\": \"replace\",\"path\": \"/metadata/iiif.label/0/value\",\"value\": \"Test label\"}]";
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream1 = null;
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withIIIFLabel("Original label").withName("Bitstream2.png").withMimeType("image/png").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].label", (Matcher)Matchers.is((Object)"Title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].value", (Matcher)Matchers.is((Object)"Public item 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Original label")));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/bitstreams/" + bitstream2.getID()), (Object[])new Object[0]).content(patchRequestBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Test label")));
    }

    @Test
    public void findOneWithCacheEvictionAfterBitstreamRemoval() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream1 = null;
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withIIIFLabel("Original label").withName("Bitstream2.png").withMimeType("image/png").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].label", (Matcher)Matchers.is((Object)"Title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].value", (Matcher)Matchers.is((Object)"Public item 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases[1].label", (Matcher)Matchers.is((Object)"Original label")));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreams/" + bitstream2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequences[0].canvases.length()", (Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void findOneWithCacheEvictionAfterItemUpdate() throws Exception {
        String patchRequestBody = "[{\"op\": \"replace\",\"path\": \"/metadata/dc.title/0/value\",\"value\": \"Public item (revised)\"}]";
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").enableIIIF().build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream1 = null;
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1.jpg").withMimeType("image/jpeg").build();
        }
        is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");
        try {
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream2.png").withMimeType("image/png").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].label", (Matcher)Matchers.is((Object)"Title"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].value", (Matcher)Matchers.is((Object)"Public item 1")));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).content(patchRequestBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/iiif/" + publicItem1.getID() + "/manifest"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata[0].value", (Matcher)Matchers.is((Object)"Public item (revised)")));
    }
}

