/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.content.Bitstream;
import org.dspace.core.Constants;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class BundleMatcher {
    private BundleMatcher() {
    }

    public static Matcher<? super Object> matchBundle(String name, UUID uuid, String handle, int type, List<Bitstream> bitstreams) {
        return Matchers.allOf(BundleMatcher.matchProperties(name, uuid, handle, type), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.bitstreams._embedded.bitstreams", (Matcher)Matchers.containsInAnyOrder((Collection)bitstreams.stream().map(x -> BitstreamMatcher.matchBitstreamEntry(x.getID(), x.getSizeBytes())).collect(Collectors.toList()))), BundleMatcher.matchLinks(uuid));
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("bitstreams[]", "primaryBitstream", "item");
    }

    public static Matcher<? super Object> matchLinks(UUID uuid) {
        return HalMatcher.matchLinks("http://localhost/api/core/bundles/" + uuid, "item", "bitstreams", "primaryBitstream", "self");
    }

    public static Matcher<? super Object> matchProperties(String name, UUID uuid, String handle, int type) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)handle)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)Constants.typeText[type].toLowerCase())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", name)})));
    }
}

