/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model;

import org.dspace.app.rest.model.SearchConfigurationRest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SearchConfigurationRestTest {
    SearchConfigurationRest searchConfigurationRest;

    @Before
    public void setUp() throws Exception {
        this.searchConfigurationRest = new SearchConfigurationRest();
    }

    @Test
    public void testFiltersNotNullAfterConstructor() throws Exception {
        Assert.assertNotNull((Object)this.searchConfigurationRest.getFilters());
    }

    @Test
    public void testSortOptionsNotNullAfterConstructor() throws Exception {
        Assert.assertNotNull((Object)this.searchConfigurationRest.getSortOptions());
    }

    @Test
    public void testAddFilterToEmptyListAndListContainsThatFilter() throws Exception {
        SearchConfigurationRest.Filter filter = new SearchConfigurationRest.Filter();
        filter.setFilter("filter");
        this.searchConfigurationRest.addFilter(filter);
        Assert.assertEquals((Object)filter, this.searchConfigurationRest.getFilters().get(0));
    }

    @Test
    public void testAddSortOptionToEmptyListAndListContainsThatSortOption() throws Exception {
        SearchConfigurationRest.SortOption sortOption = new SearchConfigurationRest.SortOption();
        sortOption.setActualName("sort option");
        this.searchConfigurationRest.addSortOption(sortOption);
        Assert.assertEquals((Object)sortOption, this.searchConfigurationRest.getSortOptions().get(0));
    }

    @Test
    public void testAddMultipleFiltersToListAndListIsConstructedProperly() throws Exception {
        SearchConfigurationRest.Filter filter = new SearchConfigurationRest.Filter();
        filter.setFilter("filter");
        this.searchConfigurationRest.addFilter(filter);
        SearchConfigurationRest.Filter filter2 = new SearchConfigurationRest.Filter();
        filter.setFilter("filter2");
        this.searchConfigurationRest.addFilter(filter2);
        Assert.assertEquals((long)2L, (long)this.searchConfigurationRest.getFilters().size());
        Assert.assertTrue((this.searchConfigurationRest.getFilters().get(0) == filter || this.searchConfigurationRest.getFilters().get(0) == filter2 ? 1 : 0) != 0);
        Assert.assertTrue((this.searchConfigurationRest.getFilters().get(1) == filter || this.searchConfigurationRest.getFilters().get(1) == filter2 ? 1 : 0) != 0);
    }

    @Test
    public void testAddMultipleSortOptionsToListAndListIsConstructedProperly() throws Exception {
        SearchConfigurationRest.SortOption sortOption = new SearchConfigurationRest.SortOption();
        sortOption.setActualName("sort option");
        this.searchConfigurationRest.addSortOption(sortOption);
        SearchConfigurationRest.SortOption sortOption2 = new SearchConfigurationRest.SortOption();
        sortOption2.setActualName("sort option2");
        this.searchConfigurationRest.addSortOption(sortOption2);
        Assert.assertEquals((long)2L, (long)this.searchConfigurationRest.getSortOptions().size());
        Assert.assertTrue((this.searchConfigurationRest.getSortOptions().get(0) == sortOption || this.searchConfigurationRest.getSortOptions().get(0) == sortOption2 ? 1 : 0) != 0);
        Assert.assertTrue((this.searchConfigurationRest.getSortOptions().get(1) == sortOption || this.searchConfigurationRest.getSortOptions().get(1) == sortOption2 ? 1 : 0) != 0);
    }

    @Test
    public void testOperatorConstructorWithProperValueReturnsCorrectValue() throws Exception {
        SearchConfigurationRest.Filter.Operator operator = new SearchConfigurationRest.Filter.Operator("operator");
        Assert.assertEquals((Object)"operator", (Object)operator.getOperator());
    }

    @Test
    public void testFilterGetOperatorsAfterConstructorReturnsEmptyList() throws Exception {
        SearchConfigurationRest.Filter filter = new SearchConfigurationRest.Filter();
        Assert.assertTrue((boolean)filter.getOperators().isEmpty());
    }

    @Test
    public void testFilterAddOperatorAddsProperlyAndIsIncludedInGetOperators() throws Exception {
        SearchConfigurationRest.Filter filter = new SearchConfigurationRest.Filter();
        SearchConfigurationRest.Filter.Operator operator = new SearchConfigurationRest.Filter.Operator("operator");
        filter.addOperator(operator);
        Assert.assertEquals((Object)operator, filter.getOperators().get(0));
    }

    @Test
    public void testFilterAddDefaultOperatorsToListPopulatesList() throws Exception {
        SearchConfigurationRest.Filter filter = new SearchConfigurationRest.Filter();
        filter.addDefaultOperatorsToList();
        Assert.assertTrue((!filter.getOperators().isEmpty() ? 1 : 0) != 0);
    }
}

