/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.GroupResource;
import org.dspace.app.rest.repository.CollectionRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.workflow.WorkflowService;
import org.dspace.xmlworkflow.WorkflowUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/collections/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
public class CollectionGroupRestController {
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private CollectionRestRepository collectionRestRepository;
    @Autowired
    private ConverterService converterService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private WorkflowService workflowService;

    @RequestMapping(method={RequestMethod.POST}, value={"/adminGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> postAdminGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Collection)collection);
        if (collection.getAdministrators() != null) {
            throw new UnprocessableEntityException("The collection with UUID: " + uuid + " already has an admin group");
        }
        GroupRest adminGroup = this.collectionRestRepository.createAdminGroup(context, request, collection);
        context.complete();
        GroupResource groupResource = (GroupResource)this.converterService.toResource((RestModel)adminGroup);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)groupResource);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/adminGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> deleteAdminGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Collection)collection);
        if (collection.getAdministrators() == null) {
            throw new UnprocessableEntityException("The collection with UUID: " + uuid + " doesn't have an admin group");
        }
        this.collectionRestRepository.deleteAdminGroup(context, collection);
        context.complete();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/submittersGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> postSubmittersGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageSubmittersGroup((Context)context, (Collection)collection);
        if (collection.getSubmitters() != null) {
            throw new UnprocessableEntityException("The collection with UUID: " + uuid + " already has a submitter group");
        }
        GroupRest submitterGroup = this.collectionRestRepository.createSubmitterGroup(context, request, collection);
        context.complete();
        GroupResource groupResource = (GroupResource)this.converterService.toResource((RestModel)submitterGroup);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)groupResource);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/submittersGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> deleteSubmittersGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageSubmittersGroup((Context)context, (Collection)collection);
        if (collection.getSubmitters() == null) {
            throw new UnprocessableEntityException("The collection with UUID: " + uuid + " doesn't have a submitter group");
        }
        this.collectionRestRepository.deleteSubmitterGroup(context, collection);
        context.complete();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/itemReadGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> postItemReadGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        GroupRest itemReadGroup;
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageDefaultReadGroup((Context)context, (Collection)collection);
        List itemGroups = this.authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 10);
        if (itemGroups != null && !itemGroups.isEmpty() && (itemReadGroup = (Group)itemGroups.get(0)) != null && !StringUtils.equalsIgnoreCase((CharSequence)itemReadGroup.getName(), (CharSequence)"Anonymous")) {
            throw new UnprocessableEntityException("Unable to create a new default read group because either the group already exists or multiple groups are assigned the default privileges.");
        }
        itemReadGroup = this.collectionRestRepository.createItemReadGroup(context, request, collection);
        context.complete();
        GroupResource groupResource = (GroupResource)this.converterService.toResource((RestModel)itemReadGroup);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)groupResource);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/itemReadGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> deleteItemReadGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageDefaultReadGroup((Context)context, (Collection)collection);
        List itemGroups = this.authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 10);
        if (itemGroups != null && !itemGroups.isEmpty()) {
            Group itemReadGroup = (Group)itemGroups.get(0);
            if (itemReadGroup == null || StringUtils.equalsIgnoreCase((CharSequence)itemReadGroup.getName(), (CharSequence)"Anonymous")) {
                throw new UnprocessableEntityException("Unable to delete the default read group because it's the default");
            }
        } else {
            throw new UnprocessableEntityException("The collection with UUID: " + uuid + " doesn't have an ItemReadGroup group");
        }
        this.collectionRestRepository.deleteItemReadGroup(context, collection);
        context.complete();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/bitstreamReadGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> postBitstreamReadGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Group bitstreamGroup;
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageDefaultReadGroup((Context)context, (Collection)collection);
        List bitstreamGroups = this.authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 9);
        if (bitstreamGroups != null && !bitstreamGroups.isEmpty() && (bitstreamGroup = (Group)bitstreamGroups.get(0)) != null && !StringUtils.equalsIgnoreCase((CharSequence)bitstreamGroup.getName(), (CharSequence)"Anonymous")) {
            throw new UnprocessableEntityException("Unable to create a new default read group because either the group already exists or multiple groups are assigned the default privileges.");
        }
        GroupRest bitstreamReadGroup = this.collectionRestRepository.createBitstreamReadGroup(context, request, collection);
        context.complete();
        GroupResource groupResource = (GroupResource)this.converterService.toResource((RestModel)bitstreamReadGroup);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)groupResource);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/bitstreamReadGroup"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> deleteBitstreamReadGroup(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageDefaultReadGroup((Context)context, (Collection)collection);
        List bitstreamGroups = this.authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 9);
        if (bitstreamGroups != null && !bitstreamGroups.isEmpty()) {
            Group bitstreamReadGroup = (Group)bitstreamGroups.get(0);
            if (bitstreamReadGroup == null || StringUtils.equalsIgnoreCase((CharSequence)bitstreamReadGroup.getName(), (CharSequence)"Anonymous")) {
                throw new UnprocessableEntityException("Unable to delete the default read group because it's the default");
            }
        } else {
            throw new UnprocessableEntityException("The collection with UUID: " + uuid + " doesn't have an BitstreamReadGroup group");
        }
        this.collectionRestRepository.deleteBitstreamReadGroup(context, collection);
        context.complete();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/workflowGroups/{workflowRole}"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'READ')")
    public ResponseEntity<RepresentationModel<?>> getWorkflowGroupForRole(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request, @PathVariable String workflowRole) throws Exception {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageWorkflowsGroup((Context)context, (Collection)collection);
        GroupRest groupRest = this.collectionRestRepository.getWorkflowGroupForRole(context, collection, workflowRole);
        if (groupRest == null) {
            return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
        }
        GroupResource groupResource = (GroupResource)this.converterService.toResource((RestModel)groupRest);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.OK, (HttpHeaders)new HttpHeaders(), (RepresentationModel)groupResource);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/workflowGroups/{workflowRole}"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'READ')")
    public ResponseEntity<RepresentationModel<?>> postWorkflowGroupForRole(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request, @PathVariable String workflowRole) throws Exception {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageWorkflowsGroup((Context)context, (Collection)collection);
        if (WorkflowUtils.getCollectionAndRepositoryRoles((Collection)collection).get(workflowRole) == null) {
            throw new ResourceNotFoundException("Couldn't find role for: " + workflowRole + " in the collection with UUID: " + collection.getID());
        }
        Group group = this.workflowService.getWorkflowRoleGroup(context, collection, workflowRole, null);
        if (group != null) {
            throw new UnprocessableEntityException("WorkflowGroup already exists for the role: " + workflowRole + " in collection with UUID: " + collection.getID());
        }
        GroupRest groupRest = this.collectionRestRepository.createWorkflowGroupForRole(context, request, collection, workflowRole);
        context.complete();
        GroupResource groupResource = (GroupResource)this.converterService.toResource((RestModel)groupRest);
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)groupResource);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/workflowGroups/{workflowRole}"})
    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'READ')")
    public ResponseEntity<RepresentationModel<?>> deleteWorkflowGroupForRole(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request, @PathVariable String workflowRole) throws Exception {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("No such collection: " + uuid);
        }
        AuthorizeUtil.authorizeManageWorkflowsGroup((Context)context, (Collection)collection);
        this.collectionRestRepository.deleteWorkflowGroupForRole(context, request, collection, workflowRole);
        context.complete();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }
}

