/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canSendFeedback", description="It can be used to verify if the parameter that contain recipient e-mail is configured.")
public class CanSendFeedbackFeature
implements AuthorizationFeature {
    public static final String NAME = "canSendFeedback";
    @Autowired
    private ConfigurationService configurationService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        String recipientEmail = this.configurationService.getProperty("feedback.recipient");
        return StringUtils.isNotBlank((String)recipientEmail);
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.site"};
    }
}

