/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.filter;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.dspace.core.I18nUtil;
import org.springframework.stereotype.Component;

@Component
public class ContentLanguageHeaderResponseFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        Locale[] locales = I18nUtil.getSupportedLocales();
        StringBuilder locsStr = new StringBuilder();
        for (Locale locale : locales) {
            if (locsStr.length() > 0) {
                locsStr.append(",");
            }
            locsStr.append(locale.getLanguage());
        }
        httpServletResponse.setHeader("Content-Language", locsStr.toString());
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

