/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DiscoverConfigurationConverter;
import org.dspace.app.rest.converter.DiscoverFacetConfigurationConverter;
import org.dspace.app.rest.converter.DiscoverFacetResultsConverter;
import org.dspace.app.rest.converter.DiscoverFacetsConverter;
import org.dspace.app.rest.converter.DiscoverResultConverter;
import org.dspace.app.rest.converter.DiscoverSearchSupportConverter;
import org.dspace.app.rest.model.FacetConfigurationRest;
import org.dspace.app.rest.model.FacetResultsRest;
import org.dspace.app.rest.model.SearchConfigurationRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.model.SearchSupportRest;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.utils.DiscoverQueryBuilder;
import org.dspace.app.rest.utils.ScopeResolver;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component(value="discover.discover")
public class DiscoveryRestRepository
extends AbstractDSpaceRestRepository {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private DiscoveryConfigurationService searchConfigurationService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private ScopeResolver scopeResolver;
    @Autowired
    private DiscoverQueryBuilder queryBuilder;
    @Autowired
    private DiscoverResultConverter discoverResultConverter;
    @Autowired
    private DiscoverConfigurationConverter discoverConfigurationConverter;
    @Autowired
    private DiscoverFacetConfigurationConverter discoverFacetConfigurationConverter;
    @Autowired
    private DiscoverSearchSupportConverter discoverSearchSupportConverter;
    @Autowired
    private DiscoverFacetResultsConverter discoverFacetResultsConverter;
    @Autowired
    private DiscoverFacetsConverter discoverFacetsConverter;

    public SearchConfigurationRest getSearchConfiguration(String dsoScope, String configuration) {
        Context context = this.obtainContext();
        IndexableObject scopeObject = this.scopeResolver.resolveScope(context, dsoScope);
        DiscoveryConfiguration discoveryConfiguration = this.searchConfigurationService.getDiscoveryConfigurationByNameOrDso(configuration, scopeObject);
        return this.discoverConfigurationConverter.convert(discoveryConfiguration, this.utils.obtainProjection());
    }

    public SearchResultsRest getSearchObjects(String query, List<String> dsoTypes, String dsoScope, String configuration, List<SearchFilter> searchFilters, Pageable page, Projection projection) {
        Context context = this.obtainContext();
        IndexableObject scopeObject = this.scopeResolver.resolveScope(context, dsoScope);
        DiscoveryConfiguration discoveryConfiguration = this.searchConfigurationService.getDiscoveryConfigurationByNameOrDso(configuration, scopeObject);
        DiscoverResult searchResult = null;
        DiscoverQuery discoverQuery = null;
        try {
            discoverQuery = this.queryBuilder.buildQuery(context, scopeObject, discoveryConfiguration, query, searchFilters, dsoTypes, page);
            searchResult = this.searchService.search(context, scopeObject, discoverQuery);
        }
        catch (SearchServiceException e) {
            log.error("Error while searching with Discovery", (Throwable)e);
            throw new IllegalArgumentException("Error while searching with Discovery: " + e.getMessage());
        }
        return this.discoverResultConverter.convert(context, query, dsoTypes, configuration, dsoScope, searchFilters, page, searchResult, discoveryConfiguration, projection);
    }

    public FacetConfigurationRest getFacetsConfiguration(String dsoScope, String configuration) {
        Context context = this.obtainContext();
        IndexableObject scopeObject = this.scopeResolver.resolveScope(context, dsoScope);
        DiscoveryConfiguration discoveryConfiguration = this.searchConfigurationService.getDiscoveryConfigurationByNameOrDso(configuration, scopeObject);
        return this.discoverFacetConfigurationConverter.convert(configuration, dsoScope, discoveryConfiguration);
    }

    public SearchSupportRest getSearchSupport() {
        return this.discoverSearchSupportConverter.convert();
    }

    public FacetResultsRest getFacetObjects(String facetName, String prefix, String query, List<String> dsoTypes, String dsoScope, String configuration, List<SearchFilter> searchFilters, Pageable page) throws SearchServiceException {
        Context context = this.obtainContext();
        IndexableObject scopeObject = this.scopeResolver.resolveScope(context, dsoScope);
        DiscoveryConfiguration discoveryConfiguration = this.searchConfigurationService.getDiscoveryConfigurationByNameOrDso(configuration, scopeObject);
        DiscoverQuery discoverQuery = this.queryBuilder.buildFacetQuery(context, scopeObject, discoveryConfiguration, prefix, query, searchFilters, dsoTypes, page, facetName);
        DiscoverResult searchResult = this.searchService.search(context, scopeObject, discoverQuery);
        FacetResultsRest facetResultsRest = this.discoverFacetResultsConverter.convert(context, facetName, prefix, query, dsoTypes, dsoScope, searchFilters, searchResult, discoveryConfiguration, page, this.utils.obtainProjection());
        return facetResultsRest;
    }

    public SearchResultsRest getAllFacets(String query, List<String> dsoTypes, String dsoScope, String configuration, List<SearchFilter> searchFilters) {
        Context context = this.obtainContext();
        PageRequest page = PageRequest.of((int)1, (int)1);
        IndexableObject scopeObject = this.scopeResolver.resolveScope(context, dsoScope);
        DiscoveryConfiguration discoveryConfiguration = this.searchConfigurationService.getDiscoveryConfigurationByNameOrDso(configuration, scopeObject);
        DiscoverResult searchResult = null;
        DiscoverQuery discoverQuery = null;
        try {
            discoverQuery = this.queryBuilder.buildQuery(context, scopeObject, discoveryConfiguration, query, searchFilters, dsoTypes, (Pageable)page);
            searchResult = this.searchService.search(context, scopeObject, discoverQuery);
        }
        catch (SearchServiceException e) {
            log.error("Error while searching with Discovery", (Throwable)e);
        }
        SearchResultsRest searchResultsRest = this.discoverFacetsConverter.convert(context, query, dsoTypes, configuration, dsoScope, searchFilters, (Pageable)page, discoveryConfiguration, searchResult, this.utils.obtainProjection());
        return searchResultsRest;
    }
}

