/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.disseminate.service.CitationDocumentService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.utils.DSpace;
import org.springframework.core.io.AbstractResource;

public class BitstreamResource
extends AbstractResource {
    private Bitstream bitstream;
    private String name;
    private UUID uuid;
    private long sizeBytes;
    private UUID currentUserUUID;
    private BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private CitationDocumentService citationDocumentService = (CitationDocumentService)new DSpace().getServiceManager().getServicesByType(CitationDocumentService.class).get(0);

    public BitstreamResource(Bitstream bitstream, String name, UUID uuid, long sizeBytes, UUID currentUserUUID) {
        this.bitstream = bitstream;
        this.name = name;
        this.uuid = uuid;
        this.sizeBytes = sizeBytes;
        this.currentUserUUID = currentUserUUID;
    }

    public String getDescription() {
        return "bitstream [" + this.uuid + "]";
    }

    public InputStream getInputStream() throws IOException {
        Context context = new Context();
        try {
            EPerson currentUser = (EPerson)this.ePersonService.find(context, this.currentUserUUID);
            context.setCurrentUser(currentUser);
            InputStream out = this.citationDocumentService.isCitationEnabledForBitstream(this.bitstream, context) != false ? (InputStream)this.citationDocumentService.makeCitedDocument(context, this.bitstream).getLeft() : this.bitstreamService.retrieve(context, this.bitstream);
            InputStream inputStream = out;
            return inputStream;
        }
        catch (SQLException | AuthorizeException e) {
            throw new IOException(e);
        }
        finally {
            try {
                context.complete();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    public String getFilename() {
        return this.name;
    }

    public long contentLength() throws IOException {
        return this.sizeBytes;
    }
}

