/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Base64;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.matcher.AuthenticationStatusMatcher;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class AuthenticationRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    private EPersonConverter ePersonConverter;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private Utils utils;
    public static final String[] PASS_ONLY = new String[]{"org.dspace.authenticate.PasswordAuthentication"};
    public static final String[] SHIB_ONLY = new String[]{"org.dspace.authenticate.ShibAuthentication"};
    public static final String[] SHIB_AND_PASS = new String[]{"org.dspace.authenticate.ShibAuthentication", "org.dspace.authenticate.PasswordAuthentication"};
    public static final String[] SHIB_AND_IP = new String[]{"org.dspace.authenticate.IPAuthentication", "org.dspace.authenticate.ShibAuthentication"};
    public static final String TRUSTED_IP = "7.7.7.7";
    public static final String UNTRUSTED_IP = "8.8.8.8";
    private Authorization authorization;
    private EPersonRest ePersonRest;
    private final String feature = "canChangePassword";

    @Before
    public void setup() throws Exception {
        super.setUp();
        AuthorizationFeature canChangePasswordFeature = this.authorizationFeatureService.find("canChangePassword");
        this.ePersonRest = this.ePersonConverter.convert(this.eperson, DefaultProjection.DEFAULT);
        this.authorization = new Authorization(this.eperson, canChangePasswordFeature, (BaseObjectRest)this.ePersonRest);
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)PASS_ONLY);
    }

    @Test
    public void testStatusAuthenticatedAsAdmin() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", AuthenticationStatusMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", AuthenticationStatusMatcher.matchLinks())).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"password"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonWithGroups(this.admin.getEmail(), "Administrator")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + this.authorization.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(this.authorization))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    @Ignore
    public void testStatusAuthenticatedAsNormalUser() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", AuthenticationStatusMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", AuthenticationStatusMatcher.matchLinks())).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"password"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonWithGroups(this.eperson.getEmail(), "Anonymous")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + this.authorization.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(this.authorization))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testStatusNotAuthenticated() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "password realm=\"DSpace REST API\""));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testStatusShibAuthenticatedWithCookie() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        String uiURL = this.configurationService.getProperty("dspace.ui.url");
        Cookie authCookie = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).header("Referer", new Object[]{"https://myshib.example.com"}).param("redirectUrl", new String[]{uiURL}).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail()).requestAttr("SHIB-SCOPED-AFFILIATION", (Object)"faculty;staff")).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)uiURL)).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN")).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andReturn().getResponse().getCookie("Authorization-cookie");
        Assert.assertNotNull((Object)authCookie);
        String token = authCookie.getValue();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("Origin", new Object[]{uiURL}).secure(true).cookie(new Cookie[]{authCookie})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
        String headerToken = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Origin", new Object[]{uiURL}).secure(true).cookie(new Cookie[]{authCookie})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.cookie().value("Authorization-cookie", "")).andExpect(MockMvcResultMatchers.header().exists("Authorization")).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN")).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        Assert.assertTrue((String)("Check tokens " + token + " and " + headerToken + " have same claims"), (boolean)this.tokenClaimsEqual(token, headerToken));
        this.getClient(headerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("Origin", new Object[]{uiURL})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
        this.getClient(headerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0]).header("Origin", new Object[]{uiURL})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShibbolethEndpointCannotBeUsedWithShibDisabled() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)PASS_ONLY);
        String uiURL = this.configurationService.getProperty("dspace.ui.url");
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).header("Referer", new Object[]{"https://myshib.example.com"}).param("redirectUrl", new String[]{uiURL}).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail()).requestAttr("SHIB-SCOPED-AFFILIATION", (Object)"faculty;staff")).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andReturn().getResponse().getHeader("Authorization");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testStatusPasswordAuthenticatedWithCookie() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Cookie authCookie = new Cookie("Authorization-cookie", token);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).secure(true).cookie(new Cookie[]{authCookie})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN"));
        String headerToken = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).secure(true).cookie(new Cookie[]{authCookie})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.cookie().value("Authorization-cookie", "")).andExpect(MockMvcResultMatchers.header().exists("Authorization")).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN")).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        Assert.assertTrue((String)("Check tokens " + token + " and " + headerToken + " have same claims"), (boolean)this.tokenClaimsEqual(token, headerToken));
        this.getClient(headerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(headerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testTwoAuthenticationTokens() throws Exception {
        String token1 = this.getAuthToken(this.eperson.getEmail(), this.password);
        Thread.sleep(1200L);
        String token2 = this.getAuthToken(this.eperson.getEmail(), this.password);
        Assert.assertNotEquals((Object)token1, (Object)token2);
        Assert.assertTrue((String)("Check tokens " + token1 + " and " + token2 + " have same claims"), (boolean)this.tokenClaimsEqual(token1, token2));
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonOnEmail(this.eperson.getEmail())));
        this.getClient(token2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonOnEmail(this.eperson.getEmail())));
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testTamperingWithToken() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.context.turnOffAuthorisationSystem();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        this.context.restoreAuthSystemState();
        String[] jwtSplit = token.split("\\.");
        String tampered = new String(Base64.getUrlEncoder().encode(new String(Base64.getUrlDecoder().decode(token.split("\\.")[1])).replaceAll("\\[]", "[\"" + internalGroup.getID() + "\"]").getBytes()));
        String tamperedToken = jwtSplit[0] + "." + tampered + "." + jwtSplit[2];
        this.getClient(tamperedToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testLogout() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed()).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent()).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testLogoutInvalidatesAllTokens() throws Exception {
        String token1 = this.getAuthToken(this.eperson.getEmail(), this.password);
        Thread.sleep(1200L);
        String token2 = this.getAuthToken(this.eperson.getEmail(), this.password);
        Assert.assertNotEquals((Object)token1, (Object)token2);
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0]));
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void testRefreshToken() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Thread.sleep(1200L);
        String newToken = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN")).andExpect(MockMvcResultMatchers.cookie().value("DSPACE-XSRF-COOKIE", "")).andExpect(MockMvcResultMatchers.header().string("DSPACE-XSRF-TOKEN", Matchers.matchesPattern((String)"[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}"))).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        Assert.assertNotEquals((Object)token, (Object)newToken);
        Assert.assertTrue((String)("Check tokens " + token + " and " + newToken + " have same claims"), (boolean)this.tokenClaimsEqual(token, newToken));
        this.getClient(newToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"password"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(newToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + this.authorization.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(this.authorization))));
        this.getClient(newToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testRefreshTokenWithInvalidCSRF() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Cookie[] cookies = new Cookie[]{new Cookie("Authorization-cookie", token)};
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf().useInvalidToken().asHeader()).secure(true).cookie(cookies)).andExpect(MockMvcResultMatchers.status().isForbidden()).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"Invalid CSRF token"))).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testLoginChangesCSRFToken() throws Exception {
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{this.eperson.getEmail()}).param("password", new String[]{this.password})).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN")).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testCannotReuseTokenFromUntrustedOrigin() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("Origin", new Object[]{"https://example.org"})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testCannotAuthenticateFromUntrustedOrigin() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Origin", new Object[]{"https://example.org"}).param("user", new String[]{this.eperson.getEmail()}).param("password", new String[]{this.password})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testReuseTokenWithDifferentIP() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("X-FORWARDED-FOR", new Object[]{"1.1.1.1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip("1.1.1.1"))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testFailedLoginResponseCode() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{this.eperson.getEmail()}).param("password", new String[]{"fakePassword"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testLoginLogoutStatusLink() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.login.href", (Matcher)Matchers.endsWith((String)"login"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.logout.href", (Matcher)Matchers.endsWith((String)"logout"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.status.href", (Matcher)Matchers.endsWith((String)"status")));
    }

    @Test
    public void testLoginAgainAfterLogout() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testLoginEmptyRequest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"Authentication failed")));
    }

    @Test
    public void testLoginGetRequest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{this.eperson.getEmail()}).param("password", new String[]{this.password})).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void testShibbolethLoginURLWithDefaultLazyURL() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        Group reviewersGroup = GroupBuilder.createGroup((Context)this.context).withName("Reviewers").build();
        this.configurationService.setProperty("authentication-shibboleth.role.faculty", (Object)"Reviewers");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "shibboleth realm=\"DSpace REST API\", location=\"https://localhost/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\""));
    }

    @Test
    public void testShibbolethLoginURLWithServerURLContainingPort() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        this.configurationService.setProperty("dspace.server.url", (Object)"http://localhost:8080/server");
        this.configurationService.setProperty("authentication-shibboleth.lazysession.secure", (Object)false);
        Group reviewersGroup = GroupBuilder.createGroup((Context)this.context).withName("Reviewers").build();
        this.configurationService.setProperty("authentication-shibboleth.role.faculty", (Object)"Reviewers");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "shibboleth realm=\"DSpace REST API\", location=\"http://localhost:8080/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%3A8080%2Fserver%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\""));
    }

    @Test
    public void testShibbolethLoginURLWithConfiguredLazyURL() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        this.configurationService.setProperty("authentication-shibboleth.lazysession.loginurl", (Object)"http://shibboleth.org/Shibboleth.sso/Login");
        Group reviewersGroup = GroupBuilder.createGroup((Context)this.context).withName("Reviewers").build();
        this.configurationService.setProperty("authentication-shibboleth.role.faculty", (Object)"Reviewers");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "shibboleth realm=\"DSpace REST API\", location=\"http://shibboleth.org/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\""));
    }

    @Test
    public void testShibbolethLoginURLWithConfiguredLazyURLWithPort() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        this.configurationService.setProperty("authentication-shibboleth.lazysession.loginurl", (Object)"http://shibboleth.org:8080/Shibboleth.sso/Login");
        Group reviewersGroup = GroupBuilder.createGroup((Context)this.context).withName("Reviewers").build();
        this.configurationService.setProperty("authentication-shibboleth.role.faculty", (Object)"Reviewers");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "shibboleth realm=\"DSpace REST API\", location=\"http://shibboleth.org:8080/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\""));
    }

    @Test
    @Ignore
    public void testShibbolethLoginRequestAttribute() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        Group reviewersGroup = GroupBuilder.createGroup((Context)this.context).withName("Reviewers").build();
        this.configurationService.setProperty("authentication-shibboleth.role.faculty", (Object)"Reviewers");
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "shibboleth realm=\"DSpace REST API\", location=\"https://localhost/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\""));
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail()).requestAttr("SHIB-SCOPED-AFFILIATION", (Object)"faculty;staff")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonWithGroups(this.eperson.getEmail(), "Anonymous", "Reviewers")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    @Ignore
    public void testShibbolethLoginRequestHeaderWithIpAuthentication() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_AND_IP);
        this.configurationService.setProperty("authentication-ip.Administrator", (Object)"123.123.123.123");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"}).with(AuthenticationRestControllerIT.ip("123.123.123.123"))).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "ip realm=\"DSpace REST API\", shibboleth realm=\"DSpace REST API\", location=\"https://localhost/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\""));
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip("123.123.123.123")).header("SHIB-MAIL", new Object[]{this.eperson.getEmail()})).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"}).with(AuthenticationRestControllerIT.ip("123.123.123.123"))).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonWithGroups(this.eperson.getEmail(), "Anonymous", "Administrator")));
        token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip("234.234.234.234")).header("SHIB-MAIL", new Object[]{this.eperson.getEmail()})).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"}).with(AuthenticationRestControllerIT.ip("234.234.234.234"))).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonWithGroups(this.eperson.getEmail(), "Anonymous")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShibbolethAndPasswordAuthentication() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_AND_PASS);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "shibboleth realm=\"DSpace REST API\", location=\"https://localhost/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\", password realm=\"DSpace REST API\""));
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"password"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + this.authorization.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(this.authorization))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail()).requestAttr("SHIB-SCOPED-AFFILIATION", (Object)"faculty;staff")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void testOnlyPasswordAuthenticationWorks() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)PASS_ONLY);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "password realm=\"DSpace REST API\""));
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void testShibbolethAuthenticationDoesNotWorkWithPassOnly() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)PASS_ONLY);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "password realm=\"DSpace REST API\""));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail()).requestAttr("SHIB-SCOPED-AFFILIATION", (Object)"faculty;staff")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testOnlyShibbolethAuthenticationWorks() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("Referer", new Object[]{"http://my.uni.edu"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("WWW-Authenticate", "shibboleth realm=\"DSpace REST API\", location=\"https://localhost/Shibboleth.sso/Login?target=http%3A%2F%2Flocalhost%2Fapi%2Fauthn%2Fshibboleth%3FredirectUrl%3Dhttp%3A%2F%2Fmy.uni.edu\""));
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail()).requestAttr("SHIB-SCOPED-AFFILIATION", (Object)"faculty;staff")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn().getResponse().getHeader("Authorization").replace("Bearer ", "");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void testPasswordAuthenticationDoesNotWorkWithShibOnly() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{this.eperson.getEmail()}).param("password", new String[]{this.password})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testShortLivedToken() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String salt = this.eperson.getSessionSalt();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/shortlivedtokens", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$.token", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"shortlivedtoken"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authn/shortlivedtokens"))).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN"));
        Assert.assertEquals((Object)salt, (Object)this.eperson.getSessionSalt());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShortLivedTokenUsingGet() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String salt = this.eperson.getSessionSalt();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shortlivedtokens", (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip(TRUSTED_IP))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.token", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"shortlivedtoken"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authn/shortlivedtokens"))).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN"));
        Assert.assertEquals((Object)salt, (Object)this.eperson.getSessionSalt());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShortLivedTokenUsingGetFromUntrustedIpShould403() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shortlivedtokens", (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip(UNTRUSTED_IP))).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShortLivedTokenUsingGetFromUntrustedIpWithForwardHeaderShould403() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shortlivedtokens", (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip(UNTRUSTED_IP)).header("X-Forwarded-For", new Object[]{TRUSTED_IP})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShortLivedTokenWithCSRFSentViaParam() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/shortlivedtokens", (Object[])new Object[0]).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf())).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShortLivedTokenNotAuthenticated() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/shortlivedtokens", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testShortLivedTokenNotAuthenticatedUsingGet() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shortlivedtokens", (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip(TRUSTED_IP))).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testShortLivedTokenToDownloadBitstream() throws Exception {
        Bitstream bitstream = this.createPrivateBitstream();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String shortLivedToken = this.getShortLivedToken(token);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content?authentication-token=" + shortLivedToken), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShortLivedTokenToDownloadBitstreamUnauthorized() throws Exception {
        Bitstream bitstream = this.createPrivateBitstream();
        this.context.turnOffAuthorisationSystem();
        EPerson testEPerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("UnauthorizedUser@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(testEPerson.getEmail(), this.password);
        String shortLivedToken = this.getShortLivedToken(token);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content?authentication-token=" + shortLivedToken), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testLoginTokenToDownloadBitstream() throws Exception {
        Bitstream bitstream = this.createPrivateBitstream();
        String loginToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content?authentication-token=" + loginToken), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(loginToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testExpiredShortLivedTokenToDownloadBitstream() throws Exception {
        Bitstream bitstream = this.createPrivateBitstream();
        this.configurationService.setProperty("jwt.shortLived.token.expiration", (Object)"1");
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String shortLivedToken = this.getShortLivedToken(token);
        Thread.sleep(1L);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content?authentication-token=" + shortLivedToken), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testShortLivedAndLoginTokenSeparation() throws Exception {
        this.configurationService.setProperty("jwt.shortLived.token.expiration", (Object)"1");
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Thread.sleep(2L);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test(expected=Exception.class)
    public void testLoginWithShortLivedToken() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String shortLivedToken = this.getShortLivedToken(token);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/authn/login?authentication-token=" + shortLivedToken), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testGenerateShortLivedTokenWithShortLivedToken() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String shortLivedToken = this.getShortLivedToken(token);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/authn/shortlivedtokens?authentication-token=" + shortLivedToken), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testGenerateShortLivedTokenWithShortLivedTokenUsingGet() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String shortLivedToken = this.getShortLivedToken(token);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authn/shortlivedtokens?authentication-token=" + shortLivedToken), (Object[])new Object[0]).with(AuthenticationRestControllerIT.ip(TRUSTED_IP))).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    private String getShortLivedToken(String loginToken) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        MvcResult mvcResult = this.getClient(loginToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/shortlivedtokens", (Object[])new Object[0])).andReturn();
        String content = mvcResult.getResponse().getContentAsString();
        Map map = (Map)mapper.readValue(content, Map.class);
        return String.valueOf(map.get("token"));
    }

    private Bitstream createPrivateBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST BUNDLE").build();
        Group staffGroup = GroupBuilder.createGroup((Context)this.context).withName("Staff").addMember(this.eperson).build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").withReaderGroup(staffGroup).build();
        }
        this.context.restoreAuthSystemState();
        return bitstream;
    }

    private boolean tokenClaimsEqual(String token1, String token2) {
        if (token1.equals(token2)) {
            return true;
        }
        try {
            SignedJWT jwt1 = SignedJWT.parse((String)token1);
            SignedJWT jwt2 = SignedJWT.parse((String)token2);
            JWTClaimsSet jwt1ClaimsSet = jwt1.getJWTClaimsSet();
            JWTClaimsSet jwt2ClaimsSet = jwt2.getJWTClaimsSet();
            Map jwt1Claims = jwt1ClaimsSet.getClaims();
            for (String claim : jwt1Claims.keySet()) {
                if (claim.equals("exp") || jwt1ClaimsSet.getClaim(claim).equals(jwt2ClaimsSet.getClaim(claim))) continue;
                return false;
            }
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

