/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.external.OrcidRestConnector;
import org.dspace.external.provider.impl.OrcidV3AuthorDataProvider;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OrcidExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    private OrcidV3AuthorDataProvider orcidV3AuthorDataProvider;

    public void onlyRunIfConfigExists() {
        if (StringUtils.isBlank((CharSequence)this.configurationService.getProperty("orcid.clientid"))) {
            Assume.assumeNoException((Throwable)new IllegalStateException("Missing ORCID credentials"));
        }
    }

    @Test
    public void findOneExternalSourcesExistingSources() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/orcid", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.hierarchical", (Matcher)Matchers.is((Object)false)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalsource")))));
    }

    @Test
    public void findOneExternalSourcesExistingSourcesWithentryValueTest() throws Exception {
        this.onlyRunIfConfigExists();
        String entry = "0000-0002-9029-1854";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/externalsources/orcid/entryValues/" + entry), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)entry)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.display", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.externalSource", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalSourceEntry"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['dc.identifier.uri'][0].value", (Matcher)Matchers.is((Object)("https://orcid.org/" + entry)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['person.familyName'][0].value", (Matcher)Matchers.is((Object)"Bollini"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['person.givenName'][0].value", (Matcher)Matchers.is((Object)"Andrea"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['person.identifier.orcid'][0].value", (Matcher)Matchers.is((Object)entry)));
    }

    @Test
    public void findOneExternalSourceEntriesApplicableQueryTest() throws Exception {
        this.onlyRunIfConfigExists();
        String q = "orcid:0000-0002-9029-1854";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/orcid/entries", (Object[])new Object[0]).param("query", new String[]{q})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0]", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.display", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.externalSource", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalSourceEntry"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.uri'][0].value", (Matcher)Matchers.is((Object)"https://orcid.org/0000-0002-9029-1854"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.familyName'][0].value", (Matcher)Matchers.is((Object)"Bollini"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.givenName'][0].value", (Matcher)Matchers.is((Object)"Andrea"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.identifier.orcid'][0].value", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")));
    }

    @Test
    public void findOneExternalSourceEntriesApplicableQueryFamilyNameAndGivenNamesTest() throws Exception {
        this.onlyRunIfConfigExists();
        String q = "family-name:bollini AND given-names:andrea";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/orcid/entries", (Object[])new Object[0]).param("query", new String[]{q})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.display", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.externalSource", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalSourceEntry")))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.uri'][0].value", (Matcher)Matchers.is((Object)"https://orcid.org/0000-0002-9029-1854"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.familyName'][0].value", (Matcher)Matchers.is((Object)"Bollini"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.givenName'][0].value", (Matcher)Matchers.is((Object)"Andrea"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.identifier.orcid'][0].value", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")));
    }

    @Test
    public void findOneExternalSourcesMockitoTest() throws Exception {
        OrcidRestConnector orcidConnector = (OrcidRestConnector)Mockito.mock(OrcidRestConnector.class);
        OrcidRestConnector realConnector = this.orcidV3AuthorDataProvider.getOrcidRestConnector();
        this.orcidV3AuthorDataProvider.setOrcidRestConnector(orcidConnector);
        Mockito.when((Object)orcidConnector.get(ArgumentMatchers.endsWith((String)"/person"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocation) {
                return this.getClass().getResourceAsStream("orcid-person-record.xml");
            }
        });
        String entry = "0000-0002-9029-1854";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/externalsources/orcid/entryValues/" + entry), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)entry)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.display", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.externalSource", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalSourceEntry")))));
        this.orcidV3AuthorDataProvider.setOrcidRestConnector(realConnector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findOneExternalSourceEntriesApplicableQueryMockitoTest() throws Exception {
        OrcidRestConnector orcidConnector = (OrcidRestConnector)Mockito.mock(OrcidRestConnector.class);
        OrcidRestConnector realConnector = this.orcidV3AuthorDataProvider.getOrcidRestConnector();
        this.orcidV3AuthorDataProvider.setOrcidRestConnector(orcidConnector);
        try {
            Mockito.when((Object)orcidConnector.get(ArgumentMatchers.startsWith((String)"search?"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

                public InputStream answer(InvocationOnMock invocation) {
                    return this.getClass().getResourceAsStream("orcid-search.xml");
                }
            });
            Mockito.when((Object)orcidConnector.get(ArgumentMatchers.endsWith((String)"/person"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

                public InputStream answer(InvocationOnMock invocation) {
                    return this.getClass().getResourceAsStream("orcid-person-record.xml");
                }
            });
            String q = "orcid:0000-0002-9029-1854";
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/orcid/entries", (Object[])new Object[0]).param("query", new String[]{q})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0]", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.display", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.externalSource", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalSourceEntry"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.uri'][0].value", (Matcher)Matchers.is((Object)"https://orcid.org/0000-0002-9029-1854"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.familyName'][0].value", (Matcher)Matchers.is((Object)"Bollini"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.givenName'][0].value", (Matcher)Matchers.is((Object)"Andrea"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.identifier.orcid'][0].value", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")));
        }
        finally {
            this.orcidV3AuthorDataProvider.setOrcidRestConnector(realConnector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findOneExternalSourceEntriesApplicableQueryFamilyNameAndGivenNamesMockitoTest() throws Exception {
        OrcidRestConnector orcidConnector = (OrcidRestConnector)Mockito.mock(OrcidRestConnector.class);
        OrcidRestConnector realConnector = this.orcidV3AuthorDataProvider.getOrcidRestConnector();
        this.orcidV3AuthorDataProvider.setOrcidRestConnector(orcidConnector);
        try {
            Mockito.when((Object)orcidConnector.get(ArgumentMatchers.startsWith((String)"search?"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

                public InputStream answer(InvocationOnMock invocation) {
                    return this.getClass().getResourceAsStream("orcid-search.xml");
                }
            });
            Mockito.when((Object)orcidConnector.get(ArgumentMatchers.endsWith((String)"/person"), (String)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<InputStream>(){

                public InputStream answer(InvocationOnMock invocation) {
                    return this.getClass().getResourceAsStream("orcid-person-record.xml");
                }
            });
            String q = "family-name:bollini AND given-names:andrea";
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/orcid/entries", (Object[])new Object[0]).param("query", new String[]{q})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.display", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"Bollini, Andrea")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.externalSource", (Matcher)Matchers.is((Object)"orcid")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalSourceEntry")))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.uri'][0].value", (Matcher)Matchers.is((Object)"https://orcid.org/0000-0002-9029-1854"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.familyName'][0].value", (Matcher)Matchers.is((Object)"Bollini"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.givenName'][0].value", (Matcher)Matchers.is((Object)"Andrea"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.identifier.orcid'][0].value", (Matcher)Matchers.is((Object)"0000-0002-9029-1854")));
        }
        finally {
            this.orcidV3AuthorDataProvider.setOrcidRestConnector(realConnector);
        }
    }
}

