/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.matcher.RegistrationMatcher;
import org.dspace.app.rest.model.RegistrationRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.dao.RegistrationDataDAO;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RegistrationRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private RegistrationDataDAO registrationDataDAO;
    @Autowired
    private ConfigurationService configurationService;

    @Test
    public void findByTokenTestExistingUserTest() throws Exception {
        String email = this.eperson.getEmail();
        this.createTokenForEmail(email);
        RegistrationData registrationData = this.registrationDataDAO.findByEmail(this.context, email);
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, this.eperson.getID()))));
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
            email = "newUser@testnewuser.com";
            this.createTokenForEmail(email);
            registrationData = this.registrationDataDAO.findByEmail(this.context, email);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, null))));
        }
        finally {
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
        }
    }

    @Test
    public void findByTokenTestNewUserTest() throws Exception {
        String email = "newUser@testnewuser.com";
        this.createTokenForEmail(email);
        RegistrationData registrationData = this.registrationDataDAO.findByEmail(this.context, email);
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, null))));
        }
        finally {
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
        }
    }

    @Test
    public void findByTokenNotExistingTokenTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registration/search/findByToken", (Object[])new Object[0]).param("token", new String[]{"ThisTokenDoesNotExist"})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private void createTokenForEmail(String email) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(email);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registrationFlowTest() throws Exception {
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        Assert.assertEquals((long)0L, (long)registrationDataList.size());
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
            String newEmail = "newEPersonTest@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertTrue((registrationDataList.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) || StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
            this.configurationService.setProperty("user.registration", (Object)false);
            newEmail = "newEPersonTestTwo@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is(401));
            Assert.assertEquals((long)2L, (long)registrationDataList.size());
            Assert.assertTrue((!StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) && !StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forgotPasswordTest() throws Exception {
        this.configurationService.setProperty("user.registration", (Object)false);
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            Assert.assertEquals((long)0L, (long)registrationDataList.size());
            ObjectMapper mapper = new ObjectMapper();
            RegistrationRest registrationRest = new RegistrationRest();
            registrationRest.setEmail(this.eperson.getEmail());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }
}

