/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.VersionConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.VersionBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanDeleteVersionFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private VersionConverter versionConverter;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private InstallItemService installItemService;
    private AuthorizationFeature canDeleteVersionFeature;
    final String feature = "canDeleteVersion";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.canDeleteVersionFeature = this.authorizationFeatureService.find("canDeleteVersion");
        this.context.restoreAuthSystemState();
    }

    @Test
    public void canDeleteVersionsFeatureTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"My test summary").build();
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, version.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.context.restoreAuthSystemState();
        VersionRest versionRest = this.versionConverter.convert(version, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        Authorization admin2Version = new Authorization(this.admin, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization eperson2Version = new Authorization(this.eperson, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization anonymous2Version = new Authorization(null, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2Version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(admin2Version))));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + eperson2Version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymous2Version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void checkCanDeleteVersionsFeatureByColAndComAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminComA = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComAdminA@test.com").withPassword(this.password).build();
        EPerson adminComB = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComBdminA@test.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol1Admin@test.com").withPassword(this.password).build();
        EPerson adminCol2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol2Admin@test.com").withPassword(this.password).build();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunityA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community A").withAdminGroup(new EPerson[]{adminComA}).build();
        CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community B").withAdminGroup(new EPerson[]{adminComB}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).withAdminGroup(new EPerson[]{adminCol1}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 2").withAdminGroup(new EPerson[]{adminCol2}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"My test summary").build();
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, version.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.context.restoreAuthSystemState();
        VersionRest versionRest = this.versionConverter.convert(version, DefaultProjection.DEFAULT);
        String tokenAdminComA = this.getAuthToken(adminComA.getEmail(), this.password);
        String tokenAdminComB = this.getAuthToken(adminComB.getEmail(), this.password);
        String tokenAdminCol1 = this.getAuthToken(adminCol1.getEmail(), this.password);
        String tokenAdminCol2 = this.getAuthToken(adminCol2.getEmail(), this.password);
        Authorization adminOfComAToVersion = new Authorization(adminComA, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization adminOfCol1ToVersion = new Authorization(adminCol1, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization adminOfComBToVersion = new Authorization(adminComB, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization adminOfCol2ToVersion = new Authorization(adminCol2, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComAToVersion.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminOfComAToVersion))));
        this.getClient(tokenAdminCol1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol1ToVersion.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminOfCol1ToVersion))));
        this.getClient(tokenAdminComB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComBToVersion.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdminCol2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol2ToVersion.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canDeleteVersionsFeatureWithVesionInSubmissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"My test summary").build();
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, version.getItem());
        this.context.restoreAuthSystemState();
        Assert.assertNotNull((Object)workspaceItem);
        VersionRest versionRest = this.versionConverter.convert(version, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        Authorization admin2Version = new Authorization(this.admin, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization eperson2Version = new Authorization(this.eperson, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization anonymous2Version = new Authorization(null, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2Version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + eperson2Version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymous2Version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canDeleteVersionFeatureAndPropertyBlockEntityEnableTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("versioning.block.entity", (Object)true);
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withEntityType("Publication").build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)itemA, (String)"My test summary").build();
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, version.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.context.restoreAuthSystemState();
        VersionRest versionRest = this.versionConverter.convert(version, DefaultProjection.DEFAULT);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization admin2ItemA = new Authorization(this.admin, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization eperson2ItemA = new Authorization(this.eperson, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization anonymous2ItemA = new Authorization(null, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + eperson2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymous2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canDeleteVersionFeatureAndPropertyBlockEntityDisabledTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("versioning.block.entity", (Object)false);
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withName("Collection 1").withEntityType("Publication").build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)itemA, (String)"My test summary").build();
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, version.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.context.restoreAuthSystemState();
        VersionRest versionRest = this.versionConverter.convert(version, DefaultProjection.DEFAULT);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization admin2ItemA = new Authorization(this.admin, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization eperson2ItemA = new Authorization(this.eperson, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        Authorization anonymous2ItemA = new Authorization(null, this.canDeleteVersionFeature, (BaseObjectRest)versionRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(admin2ItemA))));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + eperson2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymous2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

