/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanManageVersionsFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private Utils utils;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    private Item itemA;
    private ItemRest itemARest;
    private Community communityA;
    private Collection collectionA;
    private AuthorizationFeature canManageVersionsFeature;
    final String feature = "canManageVersions";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.canManageVersionsFeature = this.authorizationFeatureService.find("canManageVersions");
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("collectionA").build();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("itemA").build();
        this.context.restoreAuthSystemState();
        this.itemARest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
    }

    @Test
    public void anonymousHasNotAccessTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void epersonHasNotAccessTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void adminItemSuccessTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void canManageVersionsFeatureAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminComA = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComAdminA@test.com").withPassword(this.password).build();
        EPerson adminComB = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComBdminA@test.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol1Admin@test.com").withPassword(this.password).build();
        EPerson adminCol2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol2Admin@test.com").withPassword(this.password).build();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunityA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community A").withAdminGroup(new EPerson[]{adminComA}).build();
        CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community B").withAdminGroup(new EPerson[]{adminComB}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).withAdminGroup(new EPerson[]{adminCol1}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 2").withAdminGroup(new EPerson[]{adminCol2}).build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRestA = this.itemConverter.convert(itemA, DefaultProjection.DEFAULT);
        String tokenAdminComA = this.getAuthToken(adminComA.getEmail(), this.password);
        String tokenAdminComB = this.getAuthToken(adminComB.getEmail(), this.password);
        String tokenAdminCol1 = this.getAuthToken(adminCol1.getEmail(), this.password);
        String tokenAdminCol2 = this.getAuthToken(adminCol2.getEmail(), this.password);
        Authorization adminOfComAToItemA = new Authorization(adminComA, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfCol1ToItemA = new Authorization(adminCol1, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfComBToItemA = new Authorization(adminComB, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfCol2ToItemA = new Authorization(adminCol2, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComAToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminOfComAToItemA))));
        this.getClient(tokenAdminCol1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol1ToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminOfCol1ToItemA))));
        this.getClient(tokenAdminComB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComBToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdminCol2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol2ToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canManageVersionsFeatureAdminsAndPropertyBlockEntityEnableTest() throws Exception {
        this.configurationService.setProperty("versioning.block.entity", (Object)true);
        this.context.turnOffAuthorisationSystem();
        EPerson adminComA = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComAdminA@test.com").withPassword(this.password).build();
        EPerson adminComB = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComBdminA@test.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol1Admin@test.com").withPassword(this.password).build();
        EPerson adminCol2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol2Admin@test.com").withPassword(this.password).build();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunityA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community A").withAdminGroup(new EPerson[]{adminComA}).build();
        CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community B").withAdminGroup(new EPerson[]{adminComB}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 1").withEntityType("Publication").withSubmitterGroup(new EPerson[]{this.eperson}).withAdminGroup(new EPerson[]{adminCol1}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 2").withAdminGroup(new EPerson[]{adminCol2}).build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRestA = this.itemConverter.convert(itemA, DefaultProjection.DEFAULT);
        String tokenAdminComA = this.getAuthToken(adminComA.getEmail(), this.password);
        String tokenAdminComB = this.getAuthToken(adminComB.getEmail(), this.password);
        String tokenAdminCol1 = this.getAuthToken(adminCol1.getEmail(), this.password);
        String tokenAdminCol2 = this.getAuthToken(adminCol2.getEmail(), this.password);
        Authorization adminOfComAToItemA = new Authorization(adminComA, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfCol1ToItemA = new Authorization(adminCol1, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfComBToItemA = new Authorization(adminComB, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfCol2ToItemA = new Authorization(adminCol2, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComAToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdminCol1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol1ToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdminComB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComBToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdminCol2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol2ToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canManageVersionsFeatureAdminsAndPropertyBlockEntityDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.block.entity", (Object)false);
        this.context.turnOffAuthorisationSystem();
        EPerson adminComA = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComAdminA@test.com").withPassword(this.password).build();
        EPerson adminComB = EPersonBuilder.createEPerson((Context)this.context).withEmail("testComBdminA@test.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol1Admin@test.com").withPassword(this.password).build();
        EPerson adminCol2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("testCol2Admin@test.com").withPassword(this.password).build();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunityA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community A").withAdminGroup(new EPerson[]{adminComA}).build();
        CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("Sub Community B").withAdminGroup(new EPerson[]{adminComB}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 1").withEntityType("Publication").withSubmitterGroup(new EPerson[]{this.eperson}).withAdminGroup(new EPerson[]{adminCol1}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)subCommunityA).withName("Collection 2").withAdminGroup(new EPerson[]{adminCol2}).build();
        Item itemA = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2021-04-19").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRestA = this.itemConverter.convert(itemA, DefaultProjection.DEFAULT);
        String tokenAdminComA = this.getAuthToken(adminComA.getEmail(), this.password);
        String tokenAdminComB = this.getAuthToken(adminComB.getEmail(), this.password);
        String tokenAdminCol1 = this.getAuthToken(adminCol1.getEmail(), this.password);
        String tokenAdminCol2 = this.getAuthToken(adminCol2.getEmail(), this.password);
        Authorization adminOfComAToItemA = new Authorization(adminComA, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfCol1ToItemA = new Authorization(adminCol1, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfComBToItemA = new Authorization(adminComB, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        Authorization adminOfCol2ToItemA = new Authorization(adminCol2, this.canManageVersionsFeature, (BaseObjectRest)itemRestA);
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComAToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminOfComAToItemA))));
        this.getClient(tokenAdminCol1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol1ToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(adminOfCol1ToItemA))));
        this.getClient(tokenAdminComB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfComBToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdminCol2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + adminOfCol2ToItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

