/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import org.dspace.app.rest.matcher.HalMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class GroupMatcher {
    private GroupMatcher() {
    }

    public static Matcher<? super Object> matchGroupEntry(UUID uuid, String name) {
        return Matchers.allOf((Matcher[])new Matcher[]{GroupMatcher.matchProperties(uuid, name)});
    }

    public static Matcher<? super Object> matchGroupWithName(String name) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"group")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/eperson/groups/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.subgroups.href", (Matcher)Matchers.endsWith((String)"/subgroups")));
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("subgroups[]", "epersons[]", "object");
    }

    public static Matcher<? super Object> matchLinks(UUID uuid) {
        return HalMatcher.matchLinks("http://localhost/api/eperson/groups/" + uuid, "subgroups", "epersons", "object", "self");
    }

    private static Matcher<? super Object> matchProperties(UUID uuid, String name) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"group")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/groups/" + uuid.toString()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.subgroups.href", (Matcher)Matchers.endsWith((String)(uuid.toString() + "/subgroups"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.epersons.href", (Matcher)Matchers.endsWith((String)(uuid.toString() + "/epersons"))));
    }
}

