/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.util.ArrayList;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.EPersonRestPermissionEvaluatorPlugin;
import org.dspace.services.RequestService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.security.core.Authentication;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class EPersonRestPermissionEvaluatorPluginTest {
    @InjectMocks
    private EPersonRestPermissionEvaluatorPlugin ePersonRestPermissionEvaluatorPlugin;
    private Authentication authentication;
    @Mock
    private RequestService requestService;

    @Before
    public void setUp() throws Exception {
        this.ePersonRestPermissionEvaluatorPlugin = (EPersonRestPermissionEvaluatorPlugin)Mockito.spy(EPersonRestPermissionEvaluatorPlugin.class);
        this.authentication = (Authentication)Mockito.mock(Authentication.class);
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)"WRITE");
        Mockito.when((Object)this.ePersonRestPermissionEvaluatorPlugin.hasDSpacePermission(this.authentication, null, null, restPermission)).thenReturn((Object)true);
        ReflectionTestUtils.setField((Object)this.ePersonRestPermissionEvaluatorPlugin, (String)"requestService", (Object)this.requestService);
        Mockito.when((Object)this.requestService.getCurrentRequest()).thenReturn(null);
    }

    @Test
    public void testHasPatchPermissionAuthFails() throws Exception {
        ArrayList<Object> ops = new ArrayList<Object>();
        AddOperation addOperation = new AddOperation("/password", (Object)"testpass");
        ops.add(addOperation);
        ReplaceOperation canLoginOperation = new ReplaceOperation("/canLogin", (Object)false);
        ops.add(canLoginOperation);
        Patch patch = new Patch(ops);
        Assert.assertFalse((boolean)this.ePersonRestPermissionEvaluatorPlugin.hasPatchPermission(this.authentication, null, null, patch));
    }

    @Test
    public void testHasPatchPermissionAuthOk() throws Exception {
        ArrayList<AddOperation> ops = new ArrayList<AddOperation>();
        AddOperation addOperation = new AddOperation("/password", (Object)"testpass");
        ops.add(addOperation);
        Patch patch = new Patch(ops);
        Assert.assertTrue((boolean)this.ePersonRestPermissionEvaluatorPlugin.hasPatchPermission(this.authentication, null, null, patch));
    }
}

