/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.io.InputStream;
import java.sql.SQLException;
import org.apache.commons.cli.Options;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.impl.MockDSpaceRunnableScript;
import org.springframework.beans.factory.annotation.Autowired;

public class MockDSpaceRunnableScriptConfiguration<T extends MockDSpaceRunnableScript>
extends ScriptConfiguration<T> {
    @Autowired
    private AuthorizeService authorizeService;
    private Class<T> dspaceRunnableClass;

    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    public boolean isAllowedToExecute(Context context) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    public Options getOptions() {
        if (this.options == null) {
            Options options = new Options();
            options.addOption("r", "remove", true, "description r");
            options.getOption("r").setType(String.class);
            options.addOption("i", "index", false, "description i");
            options.getOption("i").setType(Boolean.TYPE);
            options.getOption("i").setRequired(true);
            options.addOption("f", "file", true, "source file");
            options.getOption("f").setType(InputStream.class);
            options.getOption("f").setRequired(false);
            this.options = options;
        }
        return this.options;
    }
}

