/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.VersionHistoryRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionHistoryConverter
implements DSpaceConverter<VersionHistory, VersionHistoryRest> {
    private static final Logger log = LogManager.getLogger(VersionHistoryConverter.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    private VersionHistoryService versionHistoryService;

    public VersionHistoryRest convert(VersionHistory modelObject, Projection projection) {
        Context context = this.getContext();
        VersionHistoryRest versionHistoryRest = new VersionHistoryRest();
        try {
            versionHistoryRest.setId(modelObject.getID());
            if (Objects.nonNull(context.getCurrentUser()) && this.versionHistoryService.canSeeDraftVersion(context, modelObject)) {
                versionHistoryRest.setDraftVersion(Boolean.valueOf(modelObject.hasDraftVersion()));
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return versionHistoryRest;
    }

    public Class<VersionHistory> getModelClass() {
        return VersionHistory.class;
    }

    private Context getContext() {
        Request currentRequest = this.requestService.getCurrentRequest();
        if (currentRequest != null) {
            return ContextUtil.obtainContext((HttpServletRequest)currentRequest.getHttpServletRequest());
        }
        return null;
    }
}

