/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.Arrays;
import java.util.List;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.core.Context;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="discover.browse")
public class BrowseIndexRestRepository
extends DSpaceRestRepository<BrowseIndexRest, String> {
    @PreAuthorize(value="permitAll()")
    public BrowseIndexRest findOne(Context context, String name) {
        BrowseIndex bix;
        BrowseIndexRest bi = null;
        try {
            bix = BrowseIndex.getBrowseIndex((String)name);
        }
        catch (BrowseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bix != null) {
            bi = (BrowseIndexRest)this.converter.toRest((Object)bix, this.utils.obtainProjection());
        }
        return bi;
    }

    public Page<BrowseIndexRest> findAll(Context context, Pageable pageable) {
        try {
            List<BrowseIndex> indexes = Arrays.asList(BrowseIndex.getBrowseIndices());
            return this.converter.toRestPage(indexes, pageable, (long)indexes.size(), this.utils.obtainProjection());
        }
        catch (BrowseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Class<BrowseIndexRest> getDomainClass() {
        return BrowseIndexRest.class;
    }
}

