/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.submit.ListenerProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.UploadableStep;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.ImportService;
import org.dspace.submit.listener.MetadataListener;
import org.dspace.utils.DSpace;
import org.springframework.web.multipart.MultipartFile;

public class ExtractMetadataStep
implements ListenerProcessingStep,
UploadableStep {
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private ImportService importService = (ImportService)new DSpace().getSingletonService(ImportService.class);
    private MetadataListener listener = (MetadataListener)new DSpace().getSingletonService(MetadataListener.class);
    private ThreadLocal<Map<String, List<MetadataValue>>> metadataMap = new ThreadLocal();
    private static final Logger log = LogManager.getLogger(ExtractMetadataStep.class);

    public void doPreProcessing(Context context, InProgressSubmission wsi) {
        HashMap<String, List> metadataMapValue = new HashMap<String, List>();
        for (String metadata : this.listener.getMetadataToListen()) {
            String[] tokenized = org.dspace.core.Utils.tokenize((String)metadata);
            List mm = this.itemService.getMetadata((DSpaceObject)wsi.getItem(), tokenized[0], tokenized[1], tokenized[2], "*");
            if (mm != null && !mm.isEmpty()) {
                metadataMapValue.put(metadata, mm);
                continue;
            }
            metadataMapValue.put(metadata, new ArrayList());
        }
        this.metadataMap.set(metadataMapValue);
    }

    public void doPostProcessing(Context context, InProgressSubmission wsi) {
        Map metadataMapValue = (Map)this.metadataMap.get();
        Set changedMetadata = this.getChangedMetadata(wsi.getItem(), this.listener.getMetadataToListen(), metadataMapValue);
        try {
            ExternalDataObject obj;
            if (!changedMetadata.isEmpty() && (obj = this.listener.getExternalDataObject(context, wsi.getItem(), changedMetadata)) != null) {
                HashSet<String> alreadyFilledMetadata = new HashSet<String>();
                for (MetadataValue mv : wsi.getItem().getMetadata()) {
                    alreadyFilledMetadata.add(mv.getMetadataField().toString('.'));
                }
                for (MetadataValueDTO metadataValue : obj.getMetadata()) {
                    StringJoiner joiner = new StringJoiner(".");
                    joiner.add(metadataValue.getSchema());
                    joiner.add(metadataValue.getElement());
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metadataValue.getQualifier()})) {
                        joiner.add(metadataValue.getQualifier());
                    }
                    if (alreadyFilledMetadata.contains(joiner.toString())) continue;
                    this.itemService.addMetadata(context, (DSpaceObject)wsi.getItem(), metadataValue.getSchema(), metadataValue.getElement(), metadataValue.getQualifier(), null, metadataValue.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getChangedMetadata(Item item, Set<String> listenedMedata, Map<String, List<MetadataValue>> previousValues) {
        HashSet<String> changedMetadata = new HashSet<String>();
        for (String metadata : listenedMedata) {
            List<MetadataValue> prevMetadata = previousValues.get(metadata);
            List currMetadata = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadata);
            if (prevMetadata != null) {
                if (currMetadata != null) {
                    if (CollectionUtils.isEqualCollection(prevMetadata, (Collection)currMetadata, (Equator)new /* Unavailable Anonymous Inner Class!! */)) continue;
                    changedMetadata.add(metadata);
                    continue;
                }
                if (prevMetadata.size() == 0) continue;
                changedMetadata.add(metadata);
                continue;
            }
            if (currMetadata == null || currMetadata.size() == 0) continue;
            changedMetadata.add(metadata);
        }
        return changedMetadata;
    }

    public ErrorRest upload(Context context, SubmissionService submissionService, SubmissionStepConfig stepConfig, InProgressSubmission wsi, MultipartFile multipartFile) throws IOException {
        Item item = wsi.getItem();
        File file = Utils.getFile((MultipartFile)multipartFile, (String)"extract-metadata-step", (String)stepConfig.getId());
        try {
            ImportRecord record = this.importService.getRecord(file, multipartFile.getOriginalFilename());
            if (record != null) {
                HashSet<String> alreadyFilledMetadata = new HashSet<String>();
                for (MetadataValue mv : item.getMetadata()) {
                    alreadyFilledMetadata.add(mv.getMetadataField().toString('.'));
                }
                for (MetadatumDTO metadataValue : record.getValueList()) {
                    StringJoiner joiner = new StringJoiner(".");
                    joiner.add(metadataValue.getSchema());
                    joiner.add(metadataValue.getElement());
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metadataValue.getQualifier()})) {
                        joiner.add(metadataValue.getQualifier());
                    }
                    if (alreadyFilledMetadata.contains(joiner.toString())) continue;
                    this.itemService.addMetadata(context, (DSpaceObject)item, metadataValue.getSchema(), metadataValue.getElement(), metadataValue.getQualifier(), null, metadataValue.getValue());
                }
            }
        }
        catch (Exception e) {
            log.error("Error processing data", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            file.delete();
        }
        return null;
    }
}

