/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.AuthenticationStatusRest;
import org.dspace.app.rest.model.AuthenticationTokenRest;
import org.dspace.app.rest.model.AuthnRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.hateoas.AuthenticationStatusResource;
import org.dspace.app.rest.model.hateoas.AuthenticationTokenResource;
import org.dspace.app.rest.model.hateoas.AuthnResource;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.wrapper.AuthenticationToken;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.service.ClientInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/authn"})
@RestController
public class AuthenticationRestController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationRestController.class);
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private EPersonConverter ePersonConverter;
    @Autowired
    private HalLinkService halLinkService;
    @Autowired
    private RestAuthenticationService restAuthenticationService;
    @Autowired
    private ClientInfoService clientInfoService;
    @Autowired
    private Utils utils;

    public void afterPropertiesSet() {
        this.discoverableEndpointsService.register(this, Arrays.asList(Link.of((String)"/api/authn", (String)"authn")));
    }

    @RequestMapping(method={RequestMethod.GET})
    public AuthnResource authn() {
        AuthnRest authnRest = new AuthnRest();
        authnRest.setProjection(this.utils.obtainProjection());
        return (AuthnResource)((Object)this.converter.toResource(authnRest));
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    public AuthenticationStatusResource status(HttpServletRequest request, HttpServletResponse response) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        EPersonRest ePersonRest = null;
        Projection projection = this.utils.obtainProjection();
        if (context.getCurrentUser() != null) {
            ePersonRest = (EPersonRest)this.converter.toRest(context.getCurrentUser(), projection);
        }
        List<GroupRest> groupList = context.getSpecialGroups().stream().map(g -> (GroupRest)this.converter.toRest(g, projection)).collect(Collectors.toList());
        AuthenticationStatusRest authenticationStatusRest = new AuthenticationStatusRest(ePersonRest);
        if (!authenticationStatusRest.isAuthenticated()) {
            String authenticateHeaderValue = this.restAuthenticationService.getWwwAuthenticateHeaderValue(request, response);
            response.setHeader("WWW-Authenticate", authenticateHeaderValue);
        }
        authenticationStatusRest.setAuthenticationMethod(context.getAuthenticationMethod());
        authenticationStatusRest.setProjection(projection);
        authenticationStatusRest.setSpecialGroups(groupList);
        AuthenticationStatusResource authenticationStatusResource = (AuthenticationStatusResource)((Object)this.converter.toResource(authenticationStatusRest));
        return authenticationStatusResource;
    }

    @RequestMapping(value={"/status/specialGroups"}, method={RequestMethod.GET})
    public EntityModel retrieveSpecialGroups(Pageable page, PagedResourcesAssembler assembler, HttpServletRequest request, HttpServletResponse response) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        Projection projection = this.utils.obtainProjection();
        List groupList = context.getSpecialGroups().stream().map(g -> (GroupRest)this.converter.toRest(g, projection)).collect(Collectors.toList());
        Page groupPage = this.utils.getPage(groupList, page);
        Link link = WebMvcLinkBuilder.linkTo((Object)((AuthenticationRestController)WebMvcLinkBuilder.methodOn(AuthenticationRestController.class, (Object[])new Object[0])).retrieveSpecialGroups(page, assembler, request, response)).withSelfRel();
        return EntityModel.of((Object)new EmbeddedPage(link.getHref(), groupPage.map(this.converter::toResource), null, "specialGroups"));
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public ResponseEntity login(HttpServletRequest request, @RequestParam(name="user", required=false) String user, @RequestParam(name="password", required=false) String password) {
        return this.getLoginResponse(request, "Authentication failed. The credentials you provided are not valid.");
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @RequestMapping(value={"/shortlivedtokens"}, method={RequestMethod.POST})
    public AuthenticationTokenResource shortLivedToken(HttpServletRequest request) {
        return this.shortLivedTokenResponse(request);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @RequestMapping(value={"/shortlivedtokens"}, method={RequestMethod.GET})
    public AuthenticationTokenResource shortLivedTokenViaGet(HttpServletRequest request) throws AuthorizeException {
        if (!this.clientInfoService.isRequestFromTrustedProxy(request.getRemoteAddr())) {
            throw new AuthorizeException("Requests to this endpoint should be made from a trusted IP address.");
        }
        return this.shortLivedTokenResponse(request);
    }

    private AuthenticationTokenResource shortLivedTokenResponse(HttpServletRequest request) {
        Projection projection = this.utils.obtainProjection();
        AuthenticationToken shortLivedToken = this.restAuthenticationService.getShortLivedAuthenticationToken(ContextUtil.obtainContext(request), request);
        AuthenticationTokenRest authenticationTokenRest = (AuthenticationTokenRest)this.converter.toRest(shortLivedToken, projection);
        return (AuthenticationTokenResource)((Object)this.converter.toResource(authenticationTokenRest));
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public ResponseEntity login() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).body((Object)"Only POST is allowed for login requests.");
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.HEAD, RequestMethod.POST})
    public ResponseEntity logout() {
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public ResponseEntity logoutMethodNotAllowed() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).body((Object)"Only POST is allowed for logout requests.");
    }

    protected ResponseEntity getLoginResponse(HttpServletRequest request, String failedMessage) {
        Context context = null;
        context = ContextUtil.obtainContext(request);
        if (context == null || context.getCurrentUser() == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)failedMessage);
        }
        return ResponseEntity.ok().build();
    }
}

