/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/authz/resourcepolicies/{id:\\d+}/eperson"})
public class ResourcePolicyEPersonReplaceRestController {
    @Autowired
    private Utils utils;
    @Autowired
    private ResourcePolicyService resourcePolicyService;

    @PreAuthorize(value="hasPermission(#id, 'resourcepolicy', 'ADMIN')")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"text/uri-list"})
    public ResponseEntity<RepresentationModel<?>> replaceEPersonOfResourcePolicy(@PathVariable Integer id, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        List<DSpaceObject> dsoList = this.utils.constructDSpaceObjectList(context, this.utils.getStringListFromRequest(request));
        if (dsoList.size() != 1 || dsoList.get(0).getType() != 7) {
            throw new UnprocessableEntityException("The EPerson doesn't exist or the data cannot be resolved to an EPerson.");
        }
        ResourcePolicy resourcePolicy = (ResourcePolicy)this.resourcePolicyService.find(context, id.intValue());
        if (Objects.isNull(resourcePolicy)) {
            throw new ResourceNotFoundException("ResourcePolicy with id: " + id + " not found");
        }
        if (Objects.isNull(resourcePolicy.getEPerson())) {
            throw new UnprocessableEntityException("ResourcePolicy with id:" + id + " doesn't link to an EPerson");
        }
        EPerson newEPerson = (EPerson)dsoList.get(0);
        resourcePolicy.setEPerson(newEPerson);
        context.commit();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }
}

