/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.model.hateoas.ProcessResource;
import org.dspace.app.rest.repository.ScriptRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/system/scripts/{name}/processes"})
public class ScriptProcessesController {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ConverterService converter;
    @Autowired
    private ScriptRestRepository scriptRestRepository;
    @Autowired
    private RequestService requestService;

    @RequestMapping(method={RequestMethod.POST})
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ResponseEntity<RepresentationModel<?>> startProcess(@PathVariable(name="name") String scriptName, @RequestParam(name="file", required=false) List<MultipartFile> files) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Starting Process for Script with name: " + scriptName);
        }
        Context context = ContextUtil.obtainContext(this.requestService.getCurrentRequest().getHttpServletRequest());
        ProcessRest processRest = this.scriptRestRepository.startProcess(context, scriptName, files);
        ProcessResource processResource = (ProcessResource)((Object)this.converter.toResource(processRest));
        context.complete();
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.ACCEPTED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)processResource);
    }
}

